/*Modification de : mbed TextLCD Library, for a 4-bit LCD based on HD44780
  pour la commande d'un afficheur 4x40
 */

#ifndef MBED_TEXTLCD_H
#define MBED_TEXTLCD_H

#include "mbed.h"

/** A TextLCD interface for driving 4-bit HD44780-based LCDs
 *
 *
 * @code
 * #include "mbed.h"
 * #include "TextLCD.h"
 * 
 * TextLCD lcd(p10, p12, p15, p16, p29, p30); // rs, e, d0-d3
 * 
 * int main() {
 *     lcd.printf("Hello World!\n");
 * }
 * @endcode
 */
class TextLCD_4x40 : public Stream {
public:

    /** Create a TextLCD interface
     *
     * @param rs    Instruction/data control line
     * @param e     Enable line (clock)
     * @param d0-d3 Data lines
     */
    TextLCD_4x40(PinName rs, PinName e, PinName d0, PinName d1, PinName d2, PinName d3);
    
#if DOXYGEN_ONLY
    /** Write a character to the LCD
     *
     * @param c The character to write to the display
     */
    int putc(char c);

    /** Write a formated string to the LCD
     *
     * @param format A printf-style format string, followed by the
     *               variables to use in formating the string.
     */
    char printf(const char* format, ...);
#endif

    /** Locate to a screen column and row
     *
     * @param column  The horizontal position from the left, indexed from 0
     * @param row     The vertical position from the top, indexed from 0
     */
    void locate(char column, char row);

    /** Clear the screen and locate to 0,0 */
    void cls();

protected:

    // Stream implementation functions
    virtual int _putc(int value);
    virtual int _getc();

    char address(char column, char row);
    void character(char column, char row, char c);
    void writeByte(char value);
    void writeCommand(char command);
    void writeData(char data);

    DigitalOut _rs, _e;
    BusOut _d;

    char _column;
    char _row;
};

#endif
