/*Modification de :" mbed TextLCD Library, for a 4-bit LCD based on HD44780........"
  pour la commande d'un afficheur 4x40 (M4024)
 */
#include "TextLCD_4x40.h"
#include "mbed.h"

TextLCD_4x40::TextLCD_4x40(PinName rs, PinName e, PinName d0, PinName d1, PinName d2, PinName d3) :
                        _rs(rs),_e(e), _d(d0, d1, d2, d3) {

//-------------------------------------
char  euro_v1[8]={0x06,0x09,0x1c,0x08,0x1C,0x09,0x06,0}//symbole euro
     ,e_aigu[8] ={0x02,0x04,0x0e,0x11,0x1f,0x10,0x0e,0}//e accent aigu
       ;
//-------------------------------------
char i;
    _e  = 1;
    _rs = 0;            // command mode

    wait_ms(15);        // Wait 15ms to ensure powered up

    // send "Display Settings" 3 times (Only top nibble of 0x30 as we've got 4-bit bus)
    for (char i=0; i<3; i++) {
        writeByte(0x3);
        wait_us(1640);  // this command takes 1.64ms, so wait for it
    }
    writeByte(0x2);     // 4-bit mode
    wait_us(40);    // most instructions take 40us

    writeCommand(0x28); // Function set 001 BW N F - -
    writeCommand(0x0C);
    writeCommand(0x6);  // Cursor Direction and Display Shift : 0000 01 CD S (CD 0-left, 1-right S(hift) 0-no, 1-yes
    cls();
wait_ms(6);

////////////////////// Generateur de caracteres ////////////////////////////////
//........ chargement du 1er caractere .........
   for(i=0;i<=7;i++){
         writeCommand(0x40+i);
         writeData(e_aigu[i]);
                        }
//........ chargement du 2eme caractere .........
   for(i=0;i<=7;i++){
         writeCommand(0x48+i);
         writeData(euro_v1[i]);
                        }
/////////////////////// Fin du generateur de caracteres ///////////////////////

writeCommand(2);// "home" pour que l'afficheur soit pret a afficher,
                // pour sortir du generateur de caracteres
}

void TextLCD_4x40::character(char column, char row, char c) {
    char a = address(column, row);
    writeCommand(a);
    writeData(c);
}

void TextLCD_4x40::cls() {
    writeCommand(0x01); // cls, and set cursor to 0
    wait_us(1640);     // This command takes 1.64 ms
//    locate(0, 0);
}

void TextLCD_4x40::locate(char column, char row) {
    _column = column;
    _row = row;
}

//-----------------------------
int TextLCD_4x40::_putc(int value) {
 switch(value)
   {
    case '\f':
      cls();
      break;

    case '\n':
         _column = 0;
        _row++;
        if (_row >= 2) {
            _row = 0;
        }
       break;

    case '\b':
       writeCommand(0x10);
       break;

    case '\1':
       writeData(0);
       break;
    case '\2':
       writeData(1);
       break;
    default:
       writeData(value);
       break;    
   }
 return value;
}
//-----------------------------
int TextLCD_4x40::_getc() {
    return -1;
}

void TextLCD_4x40::writeByte(char value) {
    _d = value >> 4;
    wait_us(40); // most instructions take 40us
    _e = 0;
    wait_us(40);
    _e = 1;
    _d = value >> 0;
    wait_us(40);
    _e = 0;
    wait_us(40);  // most instructions take 40us
    _e = 1;
}

void TextLCD_4x40::writeCommand(char command) {
    _rs = 0;
    writeByte(command);
}

void TextLCD_4x40::writeData(char data) {
    _rs = 1;
    writeByte(data);
}

char TextLCD_4x40::address(char column, char row) {   
            return 0x80 + (row * 0x40) + column;
}
