#include "mbed.h"
 
SPI spi(PA_7, PA_6, PA_5);          // mosi, miso, sclk
DigitalOut cs(PB_6);
DigitalOut syncPin (D8);

Serial pc(USBTX, USBRX, 9600);      // tx, rx
 
int main() {
 
    // set sync pin to known state
    syncPin  = 0;
    // Chip must be deselected
    cs = 1;
    int value = 4;
    
    spi.format(8,3);                // Setup:  bit data, high steady state clock, 2nd edge capture
    spi.frequency(1000000);         //1MHz
 
    // set sync pin high
    syncPin  = 1;
    for (int i = 0; i < 6; i++) {
        // Select device     
        cs = 0;                         
        spi.write(value);
        // Deselect device
        cs = 1;
        value++; 
    }
}