////////////// INCLUSION DES LIBRAIRIES (L1-L18)//////////////
#include "mbed.h"
#include "LEDMatrix.h"
#include "smallFont.h"
/////////////////FIN INCLUSION DES LIBRAIRIES/////////////////

//////DEFINITION LARGEUR ET LONGUEUR DE L ECRAN LED //////
#define WIDTH   64
#define HEIGHT  32
//////// FIN DEFINITION LARGEUR ET LONGUEUR DE L ECRAN LED ////////

// stb <=> latch
// LEDMatrix    (a, b,  c, d,  oe_1, r1, r2, b1, b2, g1, g2, stb_1, clk_1);
LEDMatrix matrix(D4,A2,D3,A3,D1,D8,D6,D7,D5,A0,A1,A4,D2);
Ticker scanner;

// Display Buffer
uint8_t displaybuf[2][WIDTH *HEIGHT] = {
    0x00
};


/// FONCTION DE SCAN DE L'ECRAN LED//////
void scan()
{
    matrix.scan();
}
///FIN FONCTION DE SCAN DE L'ECRAN LED//////


///////////////////////// DEBUT DU MAIN ////////////////////////////////////////
int main()
{
    
    initFonts();

    matrix.begin((uint8_t *)displaybuf, WIDTH, HEIGHT);     // Sauv en mémoire la taille de la matrice LED

    scanner.attach(scan, 1ms);   //Gère l'affiche sur la matrice LED
                                    //Un scan trop lent (>0.0009) provoque un effet de scintillement
                                    //Un scan trop rapide (<0.0001) provoque un effet d'allumage des LEDs qui sont sur la même ligne


    matrix.clear();                 //Fonction de nettoyage de la matrice, toutes les LEDs s'éteignent


    // Drapeau de la France (sur la matrice)
    matrix.drawRect(0,0,21,64,4);
    matrix.drawRect(21,0,43,64,7);// Allumage d'une zone rectangulaire sur l'écran LED
    matrix.drawRect(43,0,64,64,1);

    matrix.swap();
    while (!matrix.synchro());
    HAL_Delay(1000);
/*    matrix.clear();


    for (int i=200; i>-400; i-=4)
        {
            matrix.clear();
            matrix.drawCharString(i,0,"MATRICE LED LP SESAM",1,fonts[0]);   //Affichage de texte sur la matrice
            matrix.swap();
            wait(0.05);
            while (!matrix.synchro());
        }
        matrix.clear();*/

    ///////////// BOUCLE INFINI //////////////
    while (1);
}// FIN MAIN
///////////////////////// FIN DU MAIN ////////////////////////////////////////

