#include "mbed.h"
#include "CAN.h"

Ticker ticker;

DigitalOut led1(LED1);
DigitalOut led2(LED2);

// CAN_RS pin at Philips PCA82C250 can bus controller.
// activate transceiver by pulling this pin to GND.
// (Rise and fall slope controlled by resistor R_s)
// (+5V result in tranceiver standby mode)
// For further information see datasheet page 4
DigitalOut can_Pca82c250SlopePin(p28);

// second can controller on these pins. Not used here.
// CAN can1(p9, p10);

// We use can on mbed pins 29(CAN_TXD) and 30(CAN_RXD).
CAN can2(p30, p29);

void send() {
    static char counter = 0;
    if (can2.write(CANMessage(0x200, &counter, 1))) {
        printf("CanTx--> id: 0x200  dlc: 1  data: %x\n\r", counter);
        counter++;
    }
    // toggle led1 after every transmission
    led1 = !led1;
}

int main() {
    // 500kbit/s
    can2.frequency(500000);
    // activate external can transceiver
    can_Pca82c250SlopePin = 0;
    // every 500ms
    ticker.attach(&send, 0.5);
    /// create message object for message reception
    CANMessage can_MsgRx;
    while (1) {
        // send received messages to the pc via serial line (9k6, 8n1)
        if (can2.read(can_MsgRx)) {
            printf("CanRx--> id: 0x%x  dlc: %d  data: ", can_MsgRx.id, can_MsgRx.len);
            for (char i=0; i<can_MsgRx.len; i++) {
                printf("%x ", can_MsgRx.data[i]);
            }
            printf("\n\r");
            // any incoming message: toggle led2
            led2 = !led2;
        }
    }
}