#include "PCF8574.h"
#include "mbed.h"

PCF8574::PCF8574(PinName sda, PinName scl, int address)
        : _i2c(sda, scl) {
    _address = address;
}

int PCF8574::read(int port) {
    char foo[1];
    int num,r,i=0;
    int bin[8];
    _i2c.read(_address, foo, 1);
    num = foo[0];
     while(num!=0){
        r = num%2;
        bin[i++] = r;
        num /= 2;
    }
    return(bin[port]);
}

void PCF8574::write(int data) {
    char foo[1];
    foo[0] = data;
    _i2c.write(_address, foo, 1);
}

