#include "Clp.h"

#define HIGH 1
#define LOW 0
#define DELAY 0.5


Clp::Clp(PinName _receiverCnc,PinName _transmitterCnc,PinName _receiverElevator,PinName _transmitterElevatorEnable,PinName _transmitterElevatorSign){
    receiverCnc = new DigitalIn(_receiverCnc);
    transmitterCnc = new DigitalOut(_transmitterCnc);
    receiverElevator = new DigitalIn(_receiverElevator);
    transmitterElevatorEnable = new DigitalOut(_transmitterElevatorEnable);
    transmitterElevatorSign = new DigitalOut(_transmitterElevatorSign);
    
}

int Clp::ReceiveCnc(){
	return receiverCnc->read();
}

void Clp::TransmitCnc(){
	transmitterCnc->write(HIGH);
	wait(DELAY);
	transmitterCnc->write(LOW);
}

int Clp::ReceiveElevator(){
	return receiverElevator->read();
}

void Clp::TransmitElevator(int signal){
	transmitterElevatorSign->write(signal);
	wait(DELAY);
	transmitterElevatorEnable->write(HIGH);
	wait(DELAY);
	transmitterElevatorEnable->write(LOW);
	transmitterElevatorSign->write(LOW);
	
}