#include "mbed.h"
#include "Debug.h"
#include "Stepp.h"
#include "EixoController.h"
#include "EixoMonitoring.h" 
#include "Cnc.h"
#include "EthernetInterface.h"
#include "Clp.h"
#include "PCF8574.h"

 //=============ETHERNET==================
#define MBED_DEV_IP       "169.254.127.251"
#define MBED_DEV_MASK     "255.255.0.0"
#define MBED_DEV_GW       "0.0.0.0"
#define ECHO_SERVER_PORT   5000
//========================================
 //=============PINOS PCF=================
#define ADRESS 0x41
#define swOrignX  0//X0 --> origem
#define swEndX    1//Xf --> fim
#define swOrignY  2//X0 --> origem
#define swEndY    3//Xf --> fim
#define swOrignE  4//X0 --> origem
#define swEndE    5//Xf --> fim
#define sensorUp  6
#define sensorDown 7
//========================================
 //===========DISTANCIAS CNC==============
#define RIGHT  1
#define LEFT 0
#define DOWN 1
#define UP 0
#define dHor1 1.3591
#define dVer1 0.906
#define dCirc 1.0948
#define dVer2 0.9439
#define dNetflix 0.4908
#define dVer3 0.9816
#define dSmartv 0.4153
#define dVer4 1.2836
#define dMute 0.132
#define dHor2 3.058
#define dVer5 0.9816
#define dHor3 1.0948
#define dVer6 0.8018
#define dVoltaX 3.0202
#define dVoltaY 15.2145
#define noMove 0.0
//========================================

// =============== Pinos CLP ===============
PinName receiverCnc = p28;
PinName transmitterCnc = p27;
PinName receiverElevator = p8;
//PinName transmitterElevatorEnable = p9;
//PinName transmitterElevatorSign = p10;
PinName transmitterElevatorEnable = LED2;
PinName transmitterElevatorSign = LED4;
// ============================================
// =============== Pinos PCF ===============
PinName sda = p9;
PinName scl = p10;
// ============================================
// =============== Pinos Driver X ===============
PinName clkPinX = p21;
PinName dirPinX = p22;
PinName enPinX  = p14;

// ============================================
// =============== Pinos Driver Y ===============
PinName clkPinY = p23;
PinName dirPinY = p24;
PinName enPinY  = p13;

// ===========================================
// =============== Pinos Driver E ===============
PinName clkPinE = p25;
PinName dirPinE = p26;
PinName enPinE  = p12;

// ===========================================
//PinName valve = p11;
PinName valve = LED3;
DigitalOut eixoZ(valve);


Debug *debug  = new Debug();
PCF8574* pcf = new PCF8574(sda,scl,ADRESS);

Stepp* motorX = new Stepp(clkPinX, dirPinX, enPinX);
EixoController* eixoX = new EixoController( 44500, 17, motorX, pcf,swOrignX, swEndX);
EixoMonitoring* eixoMonitoringX = new EixoMonitoring( pcf,swOrignX, swEndX) ;
Stepp* motorY = new Stepp(clkPinY, dirPinY, enPinY);
EixoController* eixoY = new EixoController( 10000, 30, motorY,pcf, swOrignY, swEndY); //9483
EixoMonitoring* eixoMonitoringY = new EixoMonitoring( pcf,swOrignY, swEndY) ;
Stepp* motorE = new Stepp(clkPinE, dirPinE, enPinE);
EixoController* eixoE = new EixoController( 10000, 30, motorE, pcf,swOrignE, swEndE);
EixoMonitoring* eixoMonitoringE = new EixoMonitoring( pcf,swOrignE, swEndE) ;
Cnc* cnc = new Cnc(eixoX, eixoY, valve,pcf,sensorUp,sensorDown);
Clp* clp = new Clp(receiverCnc,transmitterCnc,receiverElevator,transmitterElevatorEnable,transmitterElevatorSign);

Thread thread;
Thread thread_2;
Thread thread_3;
bool control[6];
Serial pc(USBTX,USBRX);

void convert(int num,bool* bin){
    int i=0,r;
    while(num!=0){
        r = num%2;
        bin[i++] = r;
        num /= 2;
    }
}

void cnc_thread() {
    while(1){
    debug->debugPin(1,0);
    cnc->goToPosition(noMove,RIGHT,noMove,DOWN,1);//aoc1
    cnc->goToPosition(2*dHor1,RIGHT,noMove,DOWN,1);//aoc2
    cnc->goToPosition(noMove,LEFT,dVer1,DOWN,1);//aoc3
    cnc->goToPosition(dHor1,LEFT,noMove,DOWN,1);//aoc4
    cnc->goToPosition(dHor1,LEFT,noMove,DOWN,1);//aoc5
    cnc->goToPosition(noMove,LEFT,dVer1,DOWN,1);//aoc6
    cnc->goToPosition(dHor1,RIGHT,noMove,DOWN,1);//aoc7
    cnc->goToPosition(dHor1,RIGHT,noMove,DOWN,1);//aoc8
    cnc->goToPosition(noMove,LEFT,dVer1,DOWN,1);//aoc9
    cnc->goToPosition(dHor1,LEFT,noMove,DOWN,1);//aoc10
    cnc->goToPosition(dHor1,LEFT,noMove,DOWN,1);//aoc11
    cnc->goToPosition(noMove,LEFT,dVer1,DOWN,1);//aoc12
    cnc->goToPosition(dHor1,RIGHT,noMove,DOWN,1);//aoc13
    cnc->goToPosition(dHor1,RIGHT,noMove,DOWN,1);//aoc14
    cnc->goToPosition(noMove,LEFT,dVer1,DOWN,1);//aoc15
    cnc->goToPosition(dHor1,LEFT,noMove,DOWN,1);//aoc16
    cnc->goToPosition(dHor1,LEFT,noMove,DOWN,1);//aoc17
    cnc->goToPosition(noMove,LEFT,dVer1,DOWN,1);//aoc18
    cnc->goToPosition(2*dHor1,RIGHT,noMove,DOWN,1);//aoc19
    cnc->goToPosition(dHor1,LEFT,dVer1,DOWN,1); //aoc20 
    cnc->goToPosition(dCirc,LEFT,dCirc,DOWN,1); //aoc21
    cnc->goToPosition(dCirc,RIGHT,noMove,DOWN,1); //aoc22
    cnc->goToPosition(dCirc,RIGHT,noMove,DOWN,1); //aoc23
    cnc->goToPosition(dCirc,LEFT,dCirc,DOWN,1); //aoc24
    cnc->goToPosition(dHor1,LEFT,dVer2,DOWN,1); //aoc25
    cnc->goToPosition(dHor1,RIGHT,dNetflix,DOWN,1); //aoc26
    cnc->goToPosition(dHor1,RIGHT,dNetflix,UP,1); //aoc27
    cnc->goToPosition(noMove,LEFT,dVer3,DOWN,1); //aoc28
    cnc->goToPosition(dHor1,LEFT,dSmartv,DOWN,1); //aoc29
    cnc->goToPosition(dHor1,LEFT,dSmartv,UP,1); //aoc30
    cnc->goToPosition(noMove,LEFT,dVer4,DOWN,1); //aoc31
    cnc->goToPosition(dHor1,RIGHT,dMute,DOWN,1); //aoc32
    cnc->goToPosition(dHor1,RIGHT,dMute,UP,1); //aoc33
    cnc->goToPosition(dHor2-2*dHor1,RIGHT,dVer5,DOWN,1); //aoc34
    cnc->goToPosition(dHor3,LEFT,noMove,DOWN,1);//aoc35
    cnc->goToPosition(dHor3,LEFT,noMove,DOWN,1);//aoc36
    cnc->goToPosition(dHor3,LEFT,noMove,DOWN,1);//aoc37
    cnc->goToPosition(noMove,LEFT,dVer6,DOWN,1);//aoc38
    cnc->goToPosition(dHor3,RIGHT,noMove,DOWN,1);//aoc39
    cnc->goToPosition(dHor3,RIGHT,noMove,DOWN,1);//aoc40
    cnc->goToPosition(dHor3,RIGHT,noMove,DOWN,1);//aoc41
    cnc->goToPosition(noMove,LEFT,dVer6,DOWN,1);//aoc42
    cnc->goToPosition(dHor3,LEFT,noMove,DOWN,1);//aoc43
    cnc->goToPosition(dHor3,LEFT,noMove,DOWN,1);//aoc44
    cnc->goToPosition(dHor3,LEFT,noMove,DOWN,1);//aoc45
    cnc->goToPosition(noMove,LEFT,dVer6,DOWN,1);//aoc46
    cnc->goToPosition(dHor3,RIGHT,noMove,DOWN,1);//aoc47
    cnc->goToPosition(dHor3,RIGHT,noMove,DOWN,1);//aoc48
    cnc->goToPosition(dHor3,RIGHT,noMove,DOWN,1);//aoc49

    cnc->goToPosition(dVoltaX,LEFT,dVoltaY,UP,1);//RETORNAR
    debug->debugPin(1,1);
    wait(2);
    }
}

void ethernet_thread(){
    EthernetInterface eth;
    eth.init(MBED_DEV_IP, MBED_DEV_MASK, MBED_DEV_GW); //Assign a device ip, mask and gateway
    eth.connect();
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    TCPSocketConnection client;

    while (true) {
        pc.printf("\nWait for new connection...\n");
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        pc.printf("Connection from: %s\n", client.get_address());
        int num;
        char buffer[2];
        while (client.is_connected()) {
            int n = client.receive_all(buffer, sizeof(buffer));
            num = buffer[0]*10+buffer[1]-528;
            convert(num,control);
            control[5] = num>31&&num<64;
            num = 0;
            buffer[0] = 0;
            buffer[1] = 0;
            //client.send("keven\n",5);
        }
        client.close();
    }
}

void elevator_thread(){
    while(1){
        if(control[5]){
             //eixoE->goToOrigem(swOrignE,LEFT);
             clp->TransmitElevator(1);
             pc.printf("primeiro controle: %d\n",control[4]);
             eixoE->goToPosition(20,RIGHT);
             clp->TransmitElevator(control[4]);
             pc.printf("segundo controle: %d\n",control[3]);
             eixoE->goToPosition(20,RIGHT);
             clp->TransmitElevator(control[3]);
             pc.printf("terceiro controle: %d\n",control[2]);
             eixoE->goToPosition(20,RIGHT);
             clp->TransmitElevator(control[2]);
             pc.printf("quarto controle: %d\n",control[1]);
             eixoE->goToPosition(20,RIGHT);
             clp->TransmitElevator(control[1]);
             pc.printf("quinto controle: %d\n",control[0]);
             eixoE->goToPosition(20,RIGHT);
             clp->TransmitElevator(control[0]);
             control[5] = 0;
        }
    }
}


int main() {
    thread.start(cnc_thread);
    thread_2.start(ethernet_thread);
    thread_3.start(elevator_thread);
}