/*!
  @file signal.hpp

  The header of the signal base class.

  @par Full Description
  The header of the signal base class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#ifndef _SIGNAL_HPP_
#define _SIGNAL_HPP_

#include <string>

#include "mbed.h"
#include "logger.hpp"

#define FILTER_VALUE ((uint32_t)50)

class Signal
{
  public:
  Signal(const string& name, uint32_t size, Logger& logger);
  void PrintVector(uint32_t value, string& suffix, string& comment, int32_t& time_ref);
  void PrintReal(float value, string& suffix, string& comment, int32_t& time_ref);
  void PrintEvent(string& comment, int32_t time_ref);
  void TickFilter();
  void ResetFilter();
  uint32_t CheckFilter();
  
  protected:
  Logger*  m_pLogger;
  string   m_Name;
  uint32_t m_Size;
  uint32_t m_Filter;
};

#endif