/*!
  @file signal.cpp

  The implementation of the signal base class.

  @par Full Description
  The implementation of the signal base class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @li [1]    wojciech.rynczuk@wp.pl    04-MAR-2016    Removed sstream library.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "signal.hpp"
#include <cstring>

Signal::Signal(const string& name, uint32_t size, Logger& logger) : m_Name(name), m_Size(size), m_pLogger(&logger), m_Filter(0)
{
}

void Signal::PrintVector(uint32_t value, string& suffix, string& comment, int32_t& time_ref)
{
  char buffer[100];
  int32_t log_time = time_ref;
  
  if (0 == log_time)
  {
     log_time = m_pLogger->GetTime();
     time_ref = log_time;
  }
  
  snprintf(&buffer[0], 100, "#%u %s%s %d %d %s",(uint32_t)log_time, m_Name.c_str(), suffix.c_str(), value, m_Size, comment.c_str());
  m_pLogger->Log(&buffer[0]);
}
    
void Signal::PrintReal(float value, string& suffix, string& comment, int32_t& time_ref)
{
  char buffer[100];
  int32_t log_time = time_ref;
  
  if (0 == log_time)
  {
     log_time = m_pLogger->GetTime();
     time_ref = log_time;
  }
  
  snprintf(&buffer[0], 100, "#%u %s%s %f f %s",(uint32_t)log_time, m_Name.c_str(), suffix.c_str(), value, comment.c_str());
  m_pLogger->Log(&buffer[0]);
}

void Signal::PrintEvent(string& comment, int32_t time_ref)
{
  char buffer[100];
  int32_t log_time = time_ref;
  
  if (0 == log_time)
  {
     log_time = m_pLogger->GetTime();
     time_ref = log_time;
  }
  
  snprintf(&buffer[0], 100, "#%u %s e %s",(uint32_t)log_time, m_Name.c_str(), comment.c_str());
  m_pLogger->Log(&buffer[0]);
}

void Signal::TickFilter()
{
    if (FILTER_VALUE == m_Filter)
    {
        m_Filter = 1;
    }
    else
    {
        m_Filter++;
    }
}

void Signal::ResetFilter()
{
    m_Filter = 2;
}

uint32_t Signal::CheckFilter()
{
    bool ret = ((1 == m_Filter)?1:0);
    if (1 == ret)
    {
        ResetFilter();
    }
    TickFilter();
    return ret;
}