/*!
  @file magnetometer.hpp

  The header of the magnetometer signal class.

  @par Full Description
  The header of the magnetometer signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    04-MAR-2016    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "mbed.h"
#include "signal.hpp"
#include "COMPASS_DISCO_L476VG.h"

class Magnetometer : public Signal
{
  public:
  Magnetometer(const string& name, COMPASS_DISCO_L476VG &compass, Logger& logger);
  ~Magnetometer();
  
  void PrintState();
  
  private:
  COMPASS_DISCO_L476VG *m_pCompass;
  int16_t  m_MagXYZ[3];
  int16_t  m_PrevMagXYZ[3];
};
