/*!
  @file magnetometer.cpp

  The implementation of the magnetometer signal class.

  @par Full Description
  The implementation of the magnetometer signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    04-MAR-2016    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "magnetometer.hpp"

Magnetometer::Magnetometer(const string& name, COMPASS_DISCO_L476VG& compass, Logger& logger) : Signal(name, 32, logger), m_pCompass(&compass)
{
    m_MagXYZ[0] = 0;
    m_MagXYZ[1] = 0;
    m_MagXYZ[2] = 0;
    m_PrevMagXYZ[0] = 0;
    m_PrevMagXYZ[1] = 0;
    m_PrevMagXYZ[2] = 0;
}

Magnetometer::~Magnetometer()
{
}
  
void Magnetometer::PrintState()
{
    string  suffix("MagX");
    string  msg("");
    int32_t time_ref = 0;
    
    m_pCompass->MagGetXYZ(m_MagXYZ);
    if ( (CheckFilter()) || \
         (fabs((float)(m_MagXYZ[0] - m_PrevMagXYZ[0])) > 50) || \
         (fabs((float)(m_MagXYZ[1] - m_PrevMagXYZ[1])) > 50) || \
         (fabs((float)(m_MagXYZ[2] - m_PrevMagXYZ[2])) > 50))
    {
        PrintReal(m_MagXYZ[0], suffix, msg, time_ref);
        suffix = "MagY";
        time_ref = 0;
        PrintReal(m_MagXYZ[1], suffix, msg, time_ref);
        suffix = "MagZ";
        time_ref = 0;
        PrintReal(m_MagXYZ[2], suffix, msg, time_ref);
        m_PrevMagXYZ[0] = m_MagXYZ[0];
        m_PrevMagXYZ[1] = m_MagXYZ[1];
        m_PrevMagXYZ[2] = m_MagXYZ[2];
    }
}
