/*!
  @file accelerometer.cpp

  The implementation of the accelerometer signal class.

  @par Full Description
  The implementation of the accelerometer signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    04-MAR-2016    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "accelerometer.hpp"

Accelerometer::Accelerometer(const string& name, COMPASS_DISCO_L476VG& compass, Logger& logger) : Signal(name, 32, logger), m_pCompass(&compass)
{
    m_AccXYZ[0] = 0;
    m_AccXYZ[1] = 0;
    m_AccXYZ[2] = 0;
    m_PrevAccXYZ[0] = 0;
    m_PrevAccXYZ[1] = 0;
    m_PrevAccXYZ[2] = 0;
}

Accelerometer::~Accelerometer()
{
}
  
void Accelerometer::PrintState()
{
    string  suffix("AccX");
    string  msg("");
    int32_t time_ref = 0;
    
    m_pCompass->AccGetXYZ(m_AccXYZ);
    if ( (CheckFilter()) || \
         (fabs((float)(m_AccXYZ[0] - m_PrevAccXYZ[0])) > 200) || \
         (fabs((float)(m_AccXYZ[1] - m_PrevAccXYZ[1])) > 200) || \
         (fabs((float)(m_AccXYZ[2] - m_PrevAccXYZ[2])) > 200))
    {
        PrintReal(m_AccXYZ[0], suffix, msg, time_ref);
        suffix = "AccY";
        time_ref = 0;
        PrintReal(m_AccXYZ[1], suffix, msg, time_ref);
        suffix = "AccZ";
        time_ref = 0;
        PrintReal(m_AccXYZ[2], suffix, msg, time_ref);
        m_PrevAccXYZ[0] = m_AccXYZ[0];
        m_PrevAccXYZ[1] = m_AccXYZ[1];
        m_PrevAccXYZ[2] = m_AccXYZ[2];
    }
}
