/*!
  @file serialLogger.cpp

  The implementation of the serial logger class.

  @par Full Description
  The implementation of the serial logger class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @li [1]    wojciech.rynczuk@wp.pl    04-MAR-2016    DISCO L476 port.
  @endif

  @ingroup Logger

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "serialLogger.hpp"
#include "mbed.h"

SerialLogger::SerialLogger(uint32_t n_Lines, uint32_t n_Characters) : Logger(n_Lines,n_Characters)
{
    serialOut = new Serial(USBTX, USBRX);
    alarm = new DigitalOut(LED1);
    rec_indicator = new DigitalOut(LED2);
    
    serialOut->baud(115200);
    *alarm = 0;
    *rec_indicator = 0;
}

SerialLogger::~SerialLogger()
{
    delete alarm;
    delete serialOut;
}
    
void SerialLogger::Printf(const char* line)
{
    serialOut->printf("%s\n\r", line);
}
    
void SerialLogger::AlarmFull()
{
    *alarm = !*alarm;
}

uint32_t SerialLogger::StartAction()
{
    *rec_indicator = 1;
    return 0;
}

uint32_t SerialLogger::StopAction()
{
    *rec_indicator = 0;
    return 0;
}