/*!
  @file magnetometer.cpp

  The implementation of the magnetometer signal class.

  @par Full Description
  The implementation of the magnetometer signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "magnetometer.hpp"

Magnetometer::Magnetometer(const string& name, Logger& logger) : Signal(name, 32, logger)
{
    m_Magnetometer = new MAG3110(PTE25, PTE24);
    m_MagXPrev = 0;
    m_MagYPrev = 0;
    m_MagZPrev = 0;
    m_MagXCurr = 0;;
    m_MagYCurr = 0;
    m_MagZCurr = 0;
}

Magnetometer::~Magnetometer()
{
    delete m_Magnetometer;
}
  
void Magnetometer::PrintState()
{
    string  suffix("MagX");
    string  msg("");
    int32_t time_ref = 0;
    
    m_MagXCurr = m_Magnetometer->readVal(MAG_OUT_X_MSB);
    m_MagYCurr = m_Magnetometer->readVal(MAG_OUT_Y_MSB);
    m_MagZCurr = m_Magnetometer->readVal(MAG_OUT_Z_MSB);
    if ( (CheckFilter()) || \
         (fabs((float)(m_MagXCurr - m_MagXPrev)) > 50) || \
         (fabs((float)(m_MagYCurr - m_MagYPrev)) > 50) || \
         (fabs((float)(m_MagZCurr - m_MagZPrev)) > 50))
    {
        PrintVector(m_MagXCurr, suffix, msg, time_ref);
        suffix = "MagY";
        time_ref = 0;
        PrintVector(m_MagYCurr, suffix, msg, time_ref);
        suffix = "MagZ";
        time_ref = 0;
        PrintVector(m_MagZCurr, suffix, msg, time_ref);
        m_MagXPrev = m_MagXCurr;
        m_MagYPrev = m_MagYCurr;
        m_MagZPrev = m_MagZCurr;
    }
}
