/*!
  @file serialLogger.hpp

  The header of the serial logger class.

  @par Full Description
  The header of the serial logger class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @endif

  @ingroup Logger

  @par Copyright (c) MMXV Wojciech Rynczuk

  Distributed under MIT License

*/

#ifndef _SERIALLOGGER_HPP_
#define _SERIALLOGGER_HPP_

#include "mbed.h"
#include "logger.hpp"

class SerialLogger : public Logger {
    
    public:
    SerialLogger(uint32_t n_Lines, uint32_t n_Characters);
    ~SerialLogger();
    
    virtual void Printf(const char* line);
    virtual void AlarmFull();
    virtual uint32_t StartAction();
    virtual uint32_t StopAction();
    
    private:
    DigitalOut* alarm;
    DigitalOut* rec_indicator;
    Serial*     serialOut;
};
#endif