/*!
  @file slider.hpp

  The header of the slider sensor signal class.

  @par Full Description
  The header of the slider sensor signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "mbed.h"
#include "signal.hpp"
#include "TSISensor.h"

class Slider : public Signal
{
  public:
  Slider(const string& name, Logger& logger);
  
  void PrintState();
  
  private:
  TSISensor  m_Slider;
  uint32_t   m_SliderPrev;
  uint32_t   m_SliderCurr;
};
