/*!
  @file button.cpp

  The implementation of the button signal class.

  @par Full Description
  The implementation of the button signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "button.hpp"
  
Button::Button(const string& name, const PinName pin, Logger& logger) : DigitalIn(pin), Signal(name,1,logger)
{
}
    
void Button::PrintState()
{
  string  suffix("");
  int32_t time_ref = 0;
  if (read())
  {
    string msg("Key released");
    PrintVector(0, suffix, msg, time_ref);
  }
  else
  {
    string msg("Key pressed");
    PrintVector(1, suffix, msg, time_ref);
  }
}