/*!
  @file accelerometer.hpp

  The header of the accelerometer signal class.

  @par Full Description
  The header of the accelerometer signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "mbed.h"
#include "signal.hpp"
#include "MMA8451Q.h"

class Accelerometer : public Signal
{
  public:
  Accelerometer(const string& name, Logger& logger);
  ~Accelerometer();
  
  void PrintState();
  
  private:
  MMA8451Q* m_Accelerometer;
  float     m_AccXPrev;
  float     m_AccYPrev;
  float     m_AccZPrev;
  float     m_AccXCurr;
  float     m_AccYCurr;
  float     m_AccZCurr;
};
