/*!
  @file accelerometer.cpp

  The implementation of the accelerometer signal class.

  @par Full Description
  The implementation of the accelerometer signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @li [1]    wojciech.rynczuk@wp.pl    04-MAR-2016    Fixed real printing.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "accelerometer.hpp"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

Accelerometer::Accelerometer(const string& name, Logger& logger) : Signal(name, 32, logger)
{
    m_Accelerometer = new MMA8451Q(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    m_Filter = 1;
    m_AccXPrev = 0;
    m_AccYPrev = 0;
    m_AccZPrev = 0;
    m_AccXCurr = 0;
    m_AccYCurr = 0;
    m_AccZCurr = 0;
}

Accelerometer::~Accelerometer()
{
    delete m_Accelerometer;
}
  
void Accelerometer::PrintState()
{
    string  suffix("AccX");
    string  msg("");
    int32_t time_ref = 0;
    
    m_AccXCurr = m_Accelerometer->getAccX();
    m_AccYCurr = m_Accelerometer->getAccY();
    m_AccZCurr = m_Accelerometer->getAccZ();
    if ( (CheckFilter()) || \
         (fabs(m_AccXCurr - m_AccXPrev) > 0.1) || \
         (fabs(m_AccYCurr - m_AccYPrev) > 0.1) || \
         (fabs(m_AccZCurr - m_AccZPrev) > 0.1))
    {
        PrintReal(m_AccXCurr, suffix, msg, time_ref);
        suffix = "AccY";
        PrintReal(m_AccYCurr, suffix, msg, time_ref);
        suffix = "AccZ";
        PrintReal(m_AccZCurr, suffix, msg, time_ref);
        m_AccXPrev = m_AccXCurr;
        m_AccYPrev = m_AccYCurr;
        m_AccZPrev = m_AccZCurr;
    }
}
