/*!
  @file magnetometer.hpp

  The header of the magnetometer signal class.

  @par Full Description
  The header of the magnetometer signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "mbed.h"
#include "signal.hpp"
#include "MAG3110.h"

class Magnetometer : public Signal
{
  public:
  Magnetometer(const string& name, Logger& logger);
  ~Magnetometer();
  
  void PrintState();
  
  private:
  MAG3110* m_Magnetometer;
  int32_t  m_MagXPrev;
  int32_t  m_MagYPrev;
  int32_t  m_MagZPrev;
  int32_t  m_MagXCurr;
  int32_t  m_MagYCurr;
  int32_t  m_MagZCurr;
};
