/*!
  @file light.hpp

  The header of the light sensor signal class.

  @par Full Description
  The header of the light sensor signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "mbed.h"
#include "signal.hpp"

class Light : public AnalogIn, public Signal
{
  public:
  Light(const string& name, const PinName pin, Logger& logger);
  
  void PrintState();
  float m_LightPrev;
  float m_LightCurr;
};