/*!
  @file slider.cpp

  The implementation of the slider sensor signal class.

  @par Full Description
  The implementation of the slider sensor signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "slider.hpp"

Slider::Slider(const string& name, Logger& logger) : Signal(name, 7, logger)
{
    m_SliderPrev = 0;
    m_SliderCurr = 0;
}
  
void Slider::PrintState()
{
    string  suffix("");
    string  msg("");
    int32_t time_ref = 0;
    
    m_SliderCurr = m_Slider.readPercentage() * 100;
    if ( (CheckFilter()) || \
         (fabs((float)(m_SliderCurr - m_SliderPrev)) > 0))
    {
        PrintVector(m_SliderCurr, suffix, msg, time_ref);
        m_SliderPrev = m_SliderCurr;
    }
}
