/*!
  @file light.cpp

  The implementation of the light sensor signal class.

  @par Full Description
  The implementation of the light sensor signal class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @li [1]    wojciech.rynczuk@wp.pl    04-MAR-2016    Fixed real printing.
  @endif

  @ingroup Signal

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#include "light.hpp"

Light::Light(const string& name, const PinName pin, Logger& logger) : Signal(name, 1, logger), AnalogIn(pin)
{
    m_LightPrev = 0;
    m_LightCurr = 0;
}
  
void Light::PrintState()
{
    string  suffix("");
    string  msg("");
    int32_t time_ref = 0;
    
    m_LightCurr = read();
    if ( (CheckFilter()) || \
         (fabs((m_LightCurr - m_LightPrev)) > 0.1))
    {
        PrintReal(m_LightCurr, suffix, msg, time_ref);
        m_LightPrev = m_LightCurr;
    }
}