/*!
  @file logger.hpp

  The header of the logger base class.

  @par Full Description
  The header of the logger base class.

  @if REVISION_HISTORY_INCLUDED
  @par Edit History
  @li [0]    wojciech.rynczuk@wp.pl    20-JAN-2015    Initial file revision.
  @endif

  @ingroup Logger

  The MIT License (MIT)
  Copyright (c) 2016 Wojciech Rynczuk

*/

#ifndef _LOGGER_HPP_
#define _LOGGER_HPP_

#include <stdint.h>
#include "mbed.h" //Timer

class Logger {
    
    public:
    Logger(uint32_t nLines, uint32_t nCharacters);
    ~Logger();
    uint32_t Log(const char* line);
    uint32_t Print();
    int32_t  GetTime();
    void     StartRecording();
    void     StopRecording();
    bool     IsRecording();
    
    //protected:
    virtual void Printf(const char*) = 0;
    virtual void AlarmFull() = 0;
    virtual uint32_t StartAction() = 0;
    virtual uint32_t StopAction() = 0;
    
    private:
    bool     m_isRecording;
    Timer    m_Timer;
    char*    m_pLogData;
    uint32_t m_Lines;
    uint32_t m_Characters;
    uint32_t m_ReadMarker;
    volatile uint32_t m_WriteMarker;
};
   
#endif