#include "mbed.h"

#include "SLCD.h"
#include "MMA8451Q.h"

DigitalOut* myled;
DigitalOut myled1(LED_GREEN);
DigitalOut myled2(LED_RED);
Serial serial(USBTX, USBRX);

SLCD slcd;

#define MMA8451_I2C_ADDRESS (0x1d<<1)
MMA8451Q accelerometer(PTE25, PTE24, MMA8451_I2C_ADDRESS);

#include "TSISensor.h"
TSISensor tsi;

DigitalIn ON(PTC3);
DigitalIn OFF(PTC12);


int main() {
    const float delay_offset = 0.25;
    float delay = delay_offset;
    serial.baud(115200);
    while(1)
    {
        if (!ON)
        while(1) {
            // Select LED
            if (accelerometer.getAccX() < 0)
            {
                myled= &myled1;
            }
            else
            {
                myled= &myled2;
            }
        
            // Timing
            float tsi_reading = tsi.readPercentage();
            if (tsi_reading)
            {
                printf("TSI: %f\r\n",tsi_reading);
                delay = tsi_reading + delay_offset;
            }
        
            //TIC
            *myled = 1;
            printf("TIC\r\n");
            slcd.clear();
            slcd.printf("1111");
            wait(delay);
        
            //TOC
            *myled = 0;
            printf("TOC\r\n");
            slcd.clear();
            slcd.printf("0000");
            wait(delay);
        
            if (!OFF)
            {
                break;
            }
        }
    }
}
