#include "mbed.h"

//SAVE_TEST 2

PwmOut mypwm(PWM_OUT);

DigitalOut myled(LED1);


void InitializeTimer(int period = 500)
{
    RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4, ENABLE);
 
    TIM_TimeBaseInitTypeDef timerInitStructure;
    timerInitStructure.TIM_Prescaler = 40000;
    timerInitStructure.TIM_CounterMode = TIM_CounterMode_Up;
    timerInitStructure.TIM_Period = period;
    timerInitStructure.TIM_ClockDivision = TIM_CKD_DIV1;
    timerInitStructure.TIM_RepetitionCounter = 0;
    TIM_TimeBaseInit(TIM4, &timerInitStructure);
    TIM_Cmd(TIM4, ENABLE);
}


void SendPWM_Carre(int temps, PinName pin) {
    
    int middle-temps = roundUp_uint32(temps);
    PwmOut pwm(pin);
    pwm.period_ms(temps);
    pwm.pulsewidth_ms(middle-temps);
  
    printf("pwm set to %.2f %%\n", pwm.read() * 100);
    
    while(1) {
        myled = !myled;
        wait(1);
    }
    
void SendPWM_Nul(PinName pin) {
    
    
    PwmOut pwm(pin);
    
    pwm.period_ms(0);
    pwm.pulsewidth_ms(0);
  
    printf("pwm set to 0 \n");
    
    while(1) {
        myled = !myled;
        wait(1);
    }
}
