//Ne pas oublier la détection de surintensité
#include <string>
#include "mbed.h"
#include "mbed_events.h"

using namespace std;

#define PeakCurrent     510   //   Valeur à vérifier
#define _EVENT_SIZE 512

  PinName motionspin  ,
         motiondir    ,
         motionsensor = LIFTCURRENTSENSOR;

DigitalOut RED(D6);
DigitalOut GRN(D5);
DigitalOut AMB(D4);
DigitalOut myled(LED1);

Ticker timer;

PwmOut Step(motionspin);
AnalogIn Step2(motionsensor);
DigitalOut Dir2(motiondir);


class Lift {

  public:
  Lift(PinName);
  Lift();
  ~Lift();
  

  void Starting();
  void Stopping();
  void GoUp();
  void GoDown();
  
  private:

 unsigned char *trye;
// EventQueue queue(32);
Thread t;
InterruptIn _interrupt;
  
  bool InMotion;
  char sTargetPos, 
       PreviousPos, 
       CurrentPos;
  int  StepPin, 
       spinDown,
       sMiddleSensor, 
       CurrentSensor,
       tempStepPin,
       tempDirPin;    
};



void Lift::Starting(){
  int i;
  for(i=0; i<128; i++){
    Step.write(i);
    wait(10);
  }
}

void Lift::Stopping(){
  int i;
  for(i=128; i>0; i--){
    Step.write(i);
    wait(10);
  }
}

void Lift::GoUp(){
  Dir2.write(0);
  Starting();
  
}

void Lift::GoDown(){
  Dir2.write(1);
  Starting();
}


  
Lift::Lift(PinName Step2): _interrupt(Step2){ 
    //t.start(callback(&queue, &EventQueue::dispatch_forever));
    printf("Starting in context %p\r\n", Thread::gettid());
    _interrupt.mode(PullUp);
    // The 'rise' handler will execute in IRQ context
    _interrupt.rise(callback(this, &Lift::Stopping));
    // The 'fall' handler will execute in the context of thread 't'
    //_interrupt.fall(queue.event(fall_handler));
    while(1){
        sleep();            //Sleep to save power, Interrupted by Ticker and Pulse events
    }
}
