
#include "Button.h"
/** Button Constructor
  * creates an object to emulate a button on the screen
  * arguments:
  *     
  *
  */
Button::Button(rect_t arg_rect, color_t arg_color, RA8875 *arg_display, const char * arg_name)
: button_rect(arg_rect),
  button_color(arg_color),
  lcd(arg_display)
{
    int len = strlen(arg_name) + 1;
    button_name = new char[len];
    snprintf(button_name, len, "%s", arg_name);
}

Button::Button(loc_t arg_corner1_x, loc_t arg_corner1_y, loc_t arg_corner2_x, loc_t arg_corner2_y, color_t arg_color, RA8875 *arg_display, const char * arg_name)
{


    //button_name(arg_name),
    button_color = arg_color;
    lcd = arg_display;
    button_rect.p1.x = arg_corner1_x; 
    button_rect.p1.y = arg_corner1_y;
    button_rect.p2.x = arg_corner2_x;
    button_rect.p2.y = arg_corner2_y;
    int len = strlen(arg_name) + 1;
    button_name = new char[len];
    snprintf(button_name, len, "%s", arg_name);
    

}


/*

*/
//Button::Button()
//: Button(0, 0, 0, 0, RGB(0,0,0), RA8875(), string("noname"))
//{
//}
/** isPressed
  * given the current coordinates of the press, is it within the bounds of the button 
  * returns true/false
  */
bool Button::isPressed(loc_t cur_x, loc_t cur_y)
{
    /*if(corner1_x < cur_x && corner2_x > cur_x && corner1_y < cur_y && corner2_y > cur_y)
    {
        return true;
    }*/
    point_t touch_pt; 
    touch_pt.x = cur_x;
    touch_pt.y = cur_y;
    return lcd->Intersect(button_rect, touch_pt);
}

/** draw
  * will use the screen given in the constructor to draw out a rectangle and text to symbolize the button
  * returns: void
  */
void Button::draw()
{
    lcd->rect(button_rect, button_color);
    lcd->puts(button_rect.p1.x, button_rect.p1.y, button_name);
}

/** toString
  * returns a string with the values of the button 
  * used mainly for debugging
  * returns: string with values of button
  */
string Button::toString()
{
    string return_string = "Liz is awesome";
    //sprintf(return_string, "Button Name: %s\nLocation: %d,%d:%d,%d\n", button_name, corner1_x, corner1_y, corner2_x, corner2_y);
    return return_string;
}
