//
// Demo Program
//  mbed version   Graphics Working   PrintScreen Working? "/local/file.bmp"
//  v148           Yes                No,   FILE *Image = fopen(Name_BMP, "wb"); fails
//  v142           Yes                No,   FILE *Image = fopen(Name_BMP, "wb"); fails
//  v140           Yes                No,   FILE *Image = fopen(Name_BMP, "wb"); fails
//  v138           Yes                No,   FILE *Image = fopen(Name_BMP, "wb"); fails
//  v137           Yes                Yes
//  v136           Yes                Yes
//  v128           Yes                Yes
//
#include "mbed.h"           // testing: v147 - working: v146, v145, v142, v136, v128, fails: v148
#include "RA8875.h"         // v138 - tested working
#include "MyFont18x32.h"
#include "BPG_Arial08x08.h"
#include "BPG_Arial10x10.h"
#include "BPG_Arial20x20.h"
#include "BPG_Arial31x32.h"
#include "BPG_Arial63x63.h"
#include "Button.h"

// These two defines can be enabled, or commented out
//#define BIG_SCREEN
//#define CAP_TOUCH
#define LCD_C 16         // color - bits per pixel
                             // Needed for Resistive Touch
void CalibrateTS(void);
void InitTS(void); 
#ifdef CAP_TOUCH
RA8875 lcd(p5, p6, p7, p12, NC, p9,p10,p13, "tft"); // MOSI,MISO,SCK,/ChipSelect,/reset, SDA,SCL,/IRQ, name
LocalFileSystem local("local");                     // access to calibration file for resistive touch and printscreen

#else
RA8875 lcd(p5, p6, p7, p12, NC, "tft");             //MOSI, MISO, SCK, /ChipSelect, /reset, name
void InitTS(void);                                  // Needed for Resistive Touch
void CalibrateTS(void);                             // Needed for Resistive Touch
const char * TS_Config = "/local/tpcal.cfg";        // Path and file for storing touch config
LocalFileSystem local("local");                     // Needed for resistive touch config storage
#endif

#ifdef BIG_SCREEN
#define LCD_W 800
#define LCD_H 480
#else
#define LCD_W 480
#define LCD_H 272
#endif

Serial pc(USBTX, USBRX);            // And a little feedback
Timer measurement;
// 
const rect_t button_1 = {10,10,50,50}; // if intersect button_1, poin_of_touch
Button button_calibration((loc_t)10, (loc_t)10, (loc_t)50, (loc_t)50, (color_t)RGB(0,255,255), &lcd, "CAL");
Button button_data_rate_select((loc_t)10, (loc_t)10, (loc_t)20, (loc_t)20, (color_t)RGB(255,255,0), &lcd, "250");

RetCode_t callback(RA8875::filecmd_t cmd, uint8_t * buffer, uint16_t size)
{
    static FILE * fh = NULL;
    static unsigned int bytesDone = 0;
    static unsigned int totalBytes = 0;
    
    switch(cmd) {
        case RA8875::OPEN:
            bytesDone = 0;
            totalBytes = *(uint32_t *)buffer;
            pc.printf("PrintScreen callback to write %u bytes\r\n", totalBytes);
            fh = fopen("/local/file.bmp", "w+b");
            if (!fh)
                return(file_not_found);
            break;
        case RA8875::WRITE:
            bytesDone += size;
            pc.printf("  Write %d bytes => %d of %d\r\n", size, bytesDone, totalBytes);
            fwrite(buffer, 1, size, fh);
            pc.printf("  %3d %% complete\r\n", ((100 * bytesDone)/totalBytes));
            break;
        case RA8875::CLOSE:
            fclose(fh);
            pc.printf("PrintScreen Closed.\r\n");
            break;
        default:
            pc.printf("Unexpected callback %d\r\n", cmd);
            break;
    }
    return noerror;
}


int main()
{
    pc.baud(460800);                            // I like a snappy terminal, so crank it up!
    pc.printf("\r\nRA8875 Soft Fonts - Build " __DATE__ " " __TIME__ "\r\n");

    measurement.start();
    lcd.frequency(500000);
    lcd.Reset();
    lcd.init(LCD_W, LCD_H, LCD_C, 40);
    lcd.TouchPanelInit();
    #ifndef CAP_TOUCH
    InitTS();               // resistive touch calibration
    #endif 
    lcd.Backlight(.9);
    // **************************
    //RunTestSet(lcd, pc);  // If the library was compiled for test mode...

    lcd.foreground(RGB(255,255,0));
    lcd.puts(0,100, "RA8875 Soft Fonts - Build " __DATE__ " " __TIME__ "\r\n");

    lcd.SelectUserFont(Dave_Smart18x32);
    lcd.puts("**** ! Soft Fonts ! **** 0123456789\r\n");
    lcd.puts("ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
    //lcd.puts("abcdefghijklmnopqrstuvwxyz\r\n");
    lcd.SelectUserFont();
    lcd.puts("Back to normal\r\n");
    lcd.SelectUserFont(BPG_Arial08x08);
    lcd.puts("BPG_Arial08x08 ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
    //lcd.puts("BPG_Arial08x08 abcdefghijklmnopqrstuvwxyz\r\n");
    lcd.SelectUserFont(BPG_Arial10x10);
    lcd.puts("BPG_Arial10x10 ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
    //lcd.puts("BPG_Arial10x10 abcdefghijklmnopqrstuvwxyz\r\n");
    lcd.SelectUserFont(BPG_Arial20x20);
    lcd.puts("BPG_Arial20x20  ");
    lcd.SelectUserFont(BPG_Arial31x32);
    lcd.puts("BPG_Arial31x32\r\n");
    lcd.SelectUserFont(BPG_Arial63x63);
    lcd.puts("BPG_Arial63x63");
    pc.printf("Time trial completed in %d uSec\r\n", measurement.read_us());

    lcd.rect(0,0, 10,10, BrightRed);

    //pc.printf("PrintScreen activated ...\r\n");
    //RetCode_t r = lcd.PrintScreen(0,0,LCD_W,LCD_H,"/local/file.bmp", 8);
    //pc.printf("  PrintScreen returned %d - %s\r\n", r, lcd.GetErrorMessage(r));

    //lcd.AttachPrintHandler(callback);
    //lcd.PrintScreen(0,0,LCD_W,LCD_H,8);
    lcd.SelectUserFont(Dave_Smart18x32);
    button_calibration.draw();

    int cycle = 0;

    int xxxx, yyyy;
    xxxx = 0;
    yyyy = 0;
    
    while(1) 
    {
        
        TouchCode_t touch;
        
        touch = lcd.TouchPanelReadable();
        if(touch)
        {
            cycle += 1;
            
            for(int i = 0; i < lcd.TouchChannels(); i++)
            {
                TouchCode_t ev = lcd.TouchCode(i);
                point_t xy = lcd.TouchCoordinates(i); 
                uint8_t id = lcd.TouchID(i);                        // 'id' tracks the individual touches
                //TouchCode_t ev = lcd.TouchCode(i);                  // 'ev'ent indicates no_touch, touch, held, release, ...
                //point_t xy = lcd.TouchCoordinates(i);               // and of course the (x,y) coordinates
                int count = lcd.TouchCount();                       // how many simultaneous touches
                printf("%2d,%d:(%4d,%4d) \n\r", id, ev, xy.x, xy.y); 
                if(button_calibration.isPressed(xy.x, xy.y))
                {
                    //lcd.rect(0,0, LCD_W,LCD_H, BrightCyan);
                    //lcd.rect(xy.x, xy.y, xy.x+20, xy.y+20, BrightCyan);
                    if(ev == touch)
                    {
                        button_calibration.button_color = Magenta;
                    }
                    if(ev == release)
                    {
                        button_calibration.button_color = BrightCyan;
                    }
                    xxxx = xy.x;
                    yyyy = xy.y;
                };       // end
                
                
            }
            
            lcd.printf("x: %d, y: %d, cy: %d\n\r", xxxx, yyyy, cycle);
            button_calibration.draw();
        }
        
        //lcd.printf("Cycle: %i, Touch: %i\n\r", cycle, touch);
    }
}

//
//
// For the Resistive Touch Screen, the following are essential.
// For the Capacitive Touch Screen, none of the following is required.
//
//
#ifndef CAP_TOUCH
// Calibrate the resistive touch screen, and store the data on the
// file system.
//
void CalibrateTS(void)
{
    FILE * fh;
    tpMatrix_t matrix;
    RetCode_t r;
    Timer testperiod;
 
    r = lcd.TouchPanelCalibrate("Calibrate the touch panel", &matrix);
    if (r == noerror) {
        fh = fopen(TS_Config, "wb");
        if (fh) {
            fwrite(&matrix, sizeof(tpMatrix_t), 1, fh);
            fclose(fh);
            printf("  tp cal written.\r\n");
            lcd.cls();
        } else {
            printf("  couldn't open tpcal file.\r\n");
        }
    } else {
        printf("error return: %d\r\n", r);
    }
    lcd.cls();
}

// Try to load a previous resistive touch screen calibration from storage. If it
// doesn't exist, activate the touch screen calibration process.
//
void InitTS(void)
{
    FILE * fh;
    tpMatrix_t matrix;

    fh = fopen(TS_Config, "rb");
    if (fh) {
        fread(&matrix, sizeof(tpMatrix_t), 1, fh);
        fclose(fh);
        lcd.TouchPanelSetMatrix(&matrix);
        printf("  tp cal loaded.\r\n");
    } else {
        CalibrateTS();
    }
}
#endif // CAP_TOUCH 