#include "mbed.h"
#include "Sht31.h"
#include "MAX44009.h"
#include "mbed_wait_api.h"
#include <list>

Serial pc(p13,p14);
Sht31 sht31(p9, p10);
MAX44009 myMAX44009 ( p9, p10, MAX44009::MAX44009_ADDRESS_A0_GND, 400000 );
I2C i2c(p9, p10); //pins for I2C communication (SDA, SCL)

InterruptIn smthing_from_BLE(p12);
DigitalOut BLE_Can_receive(p11); // 0 = can recieve
AnalogIn input(p15);
Timer t;
class RGB{
    public :    int C;
                int R;
                int G;
                int B;
    };
class RGBf{
    public :    float C;
                float R;
                float G;
                float B;
    };  
class TandH{
    public : float t;
             float h;
    };
class myData{
    public :    int timestamp;
                unsigned short light;
                unsigned short noise;
               
    };  
    
RGB RGBdata[10];
TandH THdata[10];
float luxdata[10];
myData sleepData[1000];
int sleepDataPos=0;
int counter = 10; //to tackle with 0 mod 10 problem, use 10 instead;
int sendCounter=0; // for sending in auto/ instant measure
int _30Scounter=0;
bool allfilled = false;
RGBf RGBavg;
TandH THavg;
float luxavg;

bool wrote=false;
DigitalOut led(LED1);
char    signal[1];
//LocalFileSystem local("local"); //Create the local filesystem under the name "local"

 void letsee() {
            led=!led;
            pc.scanf("%1s", signal);
            wrote=true;
}




int main()
{   
   set_time(1587744159); 
  
    led=1;
    //pc.read
    BLE_Can_receive = 0;
    pc.baud ( 19200 );
    smthing_from_BLE.fall(&letsee);
 
       
    while(1) { 
        counter = counter%10;
        time_t seconds = time(NULL);
        t.start();
        float peakToPeak=0, signalMax=0, signalMin=1024;
        float _sample;
        int start = t.read_ms();
        while (t.read_ms() - start < 50) {
            _sample=input.read();
            if (_sample>signalMax){
                signalMax=_sample;
                }
            else if (_sample<signalMin){
                signalMin=_sample;
                }
        } 
        int end = t.read_ms();
        
    
        t.reset();
        peakToPeak = signalMax - signalMin;  // max - min = peak-peak amplitude
    
        float volts = peakToPeak * 0.707;  // convert to RMS voltage
        float first = log10(volts/0.00631)*20;
        float second = first + 94 - 44 - 25; //Gain == 11 board gain ==25
      

        //time_t seconds = time(NULL);
        {
            int sensor_addr = 41 << 1;
            char id_regval[1] = {146};
            char data[1] = {0};
            i2c.write(sensor_addr,id_regval,1, true);
            i2c.read(sensor_addr,data,1,false);

    
    // Initialize color sensor
            char timing_register[2] = {129,192};
            //char timing_register[2] = {129,0};
            i2c.write(sensor_addr,timing_register,2,false);
            char control_register[2] = {143,0};
            char temp[2]={0,0};
            //char control_register[2] = {143,3};
            i2c.write(sensor_addr,control_register,2,false);
    
            char enable_register[2] = {128,3};
            i2c.write(sensor_addr,enable_register,2,false);
    
    // Read data from color sensor (Clear/Red/Green/Blue)
    
           char clear_reg[1] = {148};
           char clear_data[2] = {0,0};
           i2c.write(sensor_addr,clear_reg,1, true);
           i2c.read(sensor_addr,clear_data,2, false);
        
           int clear_value = ((int)clear_data[1] << 8) | clear_data[0];
        
           char red_reg[1] = {150};
           char red_data[2] = {0,0};
           i2c.write(sensor_addr,red_reg,1, true);
           i2c.read(sensor_addr,red_data,2, false);
        
           int red_value = ((int)red_data[1] << 8) | red_data[0];
        
           char green_reg[1] = {152};
           char green_data[2] = {0,0};
           i2c.write(sensor_addr,green_reg,1, true);
           i2c.read(sensor_addr,green_data,2, false);
        
           int green_value = ((int)green_data[1] << 8) | green_data[0];
        
           char blue_reg[1] = {154};
           char blue_data[2] = {0,0};
           i2c.write(sensor_addr,blue_reg,1, true);
           i2c.read(sensor_addr,blue_data,2, false);
        
           int blue_value = ((int)blue_data[1] << 8) | blue_data[0];
        
                // print sensor readings
           if (allfilled == true){
                RGBavg.C = RGBavg.C*10-RGBdata[counter].C;
                RGBavg.R = RGBavg.R*10-RGBdata[counter].R;
                RGBavg.G = RGBavg.G*10-RGBdata[counter].G;
                RGBavg.B = RGBavg.B*10-RGBdata[counter].B;
            }
            RGBdata[counter].C= clear_value;
            RGBdata[counter].R= red_value;
            RGBdata[counter].G= green_value;
            RGBdata[counter].B= blue_value;
           //pc.printf("Clear (%d), Red (%d), Green (%d), Blue (%d)\n", clear_value, red_value, green_value, blue_value);
        }
        {

        MAX44009::MAX44009_status_t       aux;
        MAX44009::MAX44009_vector_data_t  myMAX44009_Data;
        
        aux  =   myMAX44009.MAX44009_Configuration ( MAX44009::CONFIGURATION_CONT_DEFAULT_MODE, MAX44009::CONFIGURATION_MANUAL_DEFAULT_MODE, MAX44009::CONFIGURATION_CDR_CURRENT_NOT_DIVIDED, MAX44009::CONFIGURATION_TIM_800_MS );
        aux  =   myMAX44009.MAX44009_GetLux( MAX44009::RESOLUTION_EXTENDED_RESOLUTION, &myMAX44009_Data );
        aux  =   myMAX44009.MAX44009_GetCurrentDivisionRatio   ( &myMAX44009_Data );
        aux  =   myMAX44009.MAX44009_GetIntegrationTime        ( &myMAX44009_Data );
        
        if (allfilled == true){
            luxavg = luxavg*10-luxdata[counter];
        } 
        
        luxdata[counter] = myMAX44009_Data.lux;
        

        }
        
        {

        //float t = sht31.readTemperature();
        //float h = sht31.readHumidity();

        if (allfilled == true){
            THavg.t = THavg.t*10-THdata[counter].t;
            THavg.h = THavg.h*10-THdata[counter].h;
        } 
        THdata[counter].t = sht31.readTemperature();
        THdata[counter].h = sht31.readHumidity();

        //pc.printf("[TEMP/HUM]");
        
        }
////////////////////////////////////////////////////////////////////
            
            /*BLE_Can_receive = 0;
            wait_ms(5);
            pc.printf("counter119\n = %d", counter);
            for (int i =0;i<10;i++){
                pc.printf("i=%d ,", i);
                pc.printf("%d,%d,%d,%d,%3.2f,%3.2f%,%0.001f\n", RGBdata[i].C, RGBdata[i].R, RGBdata[i].G, RGBdata[i].B,THdata[i].t, THdata[i].h,luxdata[i]);
            }
            BLE_Can_receive = 1;*/
            
            if (allfilled == true){
            RGBavg.C = ((RGBavg.C+RGBdata[counter].C)/10.0);
            RGBavg.R = ((RGBavg.R+RGBdata[counter].R)/10.0);
            RGBavg.G = ((RGBavg.G+RGBdata[counter].G)/10.0);
            RGBavg.B = ((RGBavg.B+RGBdata[counter].B)/10.0);
                        
            THavg.t = (THavg.t+THdata[counter].t)/10;
            THavg.h = (THavg.h+THdata[counter].h)/10;
            
            luxavg = (luxavg+luxdata[counter])/10;
            }
            else{

                    RGBavg.C= (RGBavg.C*(counter) + RGBdata[counter].C)   /(float)(counter+1);
                    RGBavg.R= (RGBavg.R*(counter) + RGBdata[counter].R)   /(float)(counter+1);
                    RGBavg.G= (RGBavg.G*(counter) + RGBdata[counter].G)   /(float)(counter+1);
                    RGBavg.B= (RGBavg.B*(counter) + RGBdata[counter].B)   /(float)(counter+1);
                    
                    THavg.t = ((THavg.t*(counter) + THdata[counter].t))/(counter+1);
                    THavg.h = ((THavg.h*(counter) + THdata[counter].h))/(counter+1);
                
                    luxavg = ((luxavg*(counter) + luxdata[counter]))/(counter+1);
            }
            
        
            BLE_Can_receive = 0;
            counter++;
            if (counter == 10 &&_30Scounter==0){
                _30Scounter=0;
               // pc.printf("%u,%u\n",(unsigned short)(luxavg*1000),(unsigned short)(second*1000));
                sleepData[sleepDataPos].timestamp=(int)seconds;
                sleepData[sleepDataPos].light=(unsigned short)(luxavg*1000);
                sleepData[sleepDataPos].noise=(unsigned short)(second*1000);
                sleepDataPos++;
                allfilled = true; 
            }
            else 
            if (counter==10){
                _30Scounter++;
                 allfilled = true; 
            }
            BLE_Can_receive = 1;
        if (wrote){
           if (signal[0]=='s'){
               for (int i=0;i <=sleepDataPos;i++){
                if (i==sleepDataPos){
                    wait_ms(500);
                    pc.printf("\"send\"");
                    }
                else {
                    float tempL=sleepData[i].light/1000.0f;
                    float tempN=sleepData[i].noise/1000.0f;
                    pc.printf("[\"%d\",\"%f\",\"%f\"],",sleepData[i].timestamp,tempL,tempN);
                    }
                }
                sleepDataPos=0;
                wrote=false;
            }
            else 
            {
                sendCounter++;
                pc.printf("%d,%d,%d,%d,%d,%3.2f,%3.2f%,%0.001f,%f\n",sendCounter,(int)(RGBavg.C+0.5), (int)(RGBavg.R+0.5), (int)(RGBavg.G+0.5), (int)(RGBavg.B+0.5),THavg.t, THavg.h,luxavg,second);
                if (sendCounter == 10){ //10 = all element is filled {  
                    if (signal[0]=='i'){
                          wait_ms(500);
                        pc.printf("end");
                    }
                    else if (signal[0]=='a')
                    {
                          wait_ms(500);
                        pc.printf("aend");
                    }
                    sendCounter=0;
                    wrote=false;
                    }
                }
            
        }


    }
}
