#include <mbed.h>

extern "C" void mbed_reset();

// Debug
BusOut leds(LED1, LED2, LED3, LED4);

// Analog Input
AnalogIn analogIn0(p20);
AnalogIn analogIn1(p19);
AnalogIn analogIn2(p17);

// Input
DigitalIn kb_dat(p9);
DigitalIn kb_clk(p10);
Ticker ps2_ticker;
int wdt = 0;
int bit = 0;
int val = 0;
int ignore = 0;
unsigned ks[256];

// Output
SPI spi(p11, p12, p13);
DigitalOut lrck(p14);
Ticker ticker;
unsigned *freqs = (unsigned *)calloc(127, sizeof(unsigned)); // Frequencies Of Each Keys
int amp = 0x00;
int da = 1;
int sweep = 0;
int fs;
int f;
int count = 0;

void sampling() {
    int outa = amp >> 3;
    lrck = 1;
    spi.write(outa);
    lrck = 0;
    spi.write(outa);
    amp = -amp;
    count++;
    if (sweep && count % 4 == 0) {
        f -= sweep;
        if (f >= 16) ticker.attach_us(&sampling, 327273 / f);
    }
}

void onTicker() {
    if (bit) {
        if (++wdt >= 10) {
            if (val == 0xF0) {
                ignore = 1;
            } else {
                if (!ignore) {
                    if (freqs[ks[val]]) {
                        f = freqs[ks[val]];
                        amp = analogIn0.read_u16();
                        da = (0xFFFF - analogIn1.read_u16()) >> 11;
                        sweep = analogIn2.read_u16() >> 12;
                        ticker.attach_us(&sampling, 327273 / f);
                        leds = ks[val];
                        leds = sweep;
                    } else {
                        //mbed_reset();
                    }
                }
                ignore = 0;
            }
            wdt = 0;
            bit = 0;
            val = 0;
        }
    }
    if (amp > 0) {
        amp -= da;
        if (amp < 0) amp = 0;
    }
}

void onKbClkFall() {
    wdt = 0;
    if (bit >= 1 && bit < 9) val += (int)kb_dat << (bit - 1);
    bit++;
}

int main() {
    // Output
    char *k = "-0987654321[poiuytrewq';lkjhgfdsa /.,mnbvcxz";    // Keyboard Layout
    unsigned f0 = 64;                                            // Frequency Of Fundamental Tone
    for (int m = 1; m <= 4; m++) {
        for (int n = 1; n <= 11; n++) freqs[*k++] = f0 * n;
        f0 = f0 * 3 / 4;
    }
    spi.format(16, 0);
    spi.frequency(1600 * 1000);

    // Input    
    ks[0x4E] = '-'; ks[0x45] = '0'; ks[0x46] = '9'; ks[0x3E] = '8'; ks[0x3D] = '7'; ks[0x36] = '6'; ks[0x2E] = '5'; ks[0x25] = '4'; ks[0x26] = '3'; ks[0x1E] = '2'; ks[0x16] = '1';
    ks[0x54] = '['; ks[0x4D] = 'p'; ks[0x44] = 'o'; ks[0x43] = 'i'; ks[0x3C] = 'u'; ks[0x35] = 'y'; ks[0x2C] = 't'; ks[0x2D] = 'r'; ks[0x24] = 'e'; ks[0x1D] = 'w'; ks[0x15] = 'q';
    ks[0x52] = '\''; ks[0x4C] = ';'; ks[0x4B] = 'l'; ks[0x42] = 'k'; ks[0x3B] = 'j'; ks[0x33] = 'h'; ks[0x34] = 'g'; ks[0x2B] = 'f'; ks[0x23] = 'd'; ks[0x1B] = 's'; ks[0x1C] = 'a';
    ks[0x29] = ' '; ks[0x4A] = '/'; ks[0x49] = '.'; ks[0x41] = ','; ks[0x3A] = 'm'; ks[0x31] = 'n'; ks[0x32] = 'b'; ks[0x2A] = 'v'; ks[0x21] = 'c'; ks[0x22] = 'x'; ks[0x1A] = 'z';
    ps2_ticker.attach_us(&onTicker, 100);
    while (1) {
        while (kb_clk) ;
        onKbClkFall();
        while (!kb_clk) ;
    }
}
