#include <mbed.h>
#include <math.h>
#define M_2PI 6.28318530717959
#define FS 20000
#define WAVE 0
#define POLY 4
Serial serial(USBTX, USBRX);
Ticker ticker;
AnalogOut analogOut(p18);
int count;
float as[POLY];
int fs[POLY];
int n;

int a = 0x8000;
float b = 1.0;
float c = 1;

void sample()
{
    int value = 0;

    for (int i = 0; i < POLY; i++) {
        value += as[i] * (fs[i] * count % FS) / FS;
        if (as[i] > 0) {
            as[i] -= b;
            if (as[i] < 0) as[i] = 0;
        } else {
            as[i] = 0;
        }
    }
    analogOut.write_u16(value);
    count++;
}

int main()
{
    int freqs[256];
    freqs[ 49] = 704; freqs[ 50] = 640; freqs[ 51] = 576; freqs[ 52] = 512; freqs[ 53] = 448; freqs[ 54] = 384;
        freqs[ 55] = 320; freqs[ 56] = 256; freqs[ 57] = 192; freqs[ 48] = 128; freqs[ 45] =  64;
      freqs[113] = 528; freqs[119] = 480; freqs[101] = 432; freqs[114] = 384; freqs[116] = 336; freqs[121] = 288;
          freqs[117] = 240; freqs[105] = 192; freqs[111] = 144; freqs[112] =  96; freqs[ 91] =  48;
        freqs[ 97] = 396; freqs[115] = 360; freqs[100] = 324; freqs[102] = 288; freqs[103] = 252; freqs[104] = 216;
            freqs[106] = 180; freqs[107] = 144; freqs[108] = 108; freqs[ 59] =  72; freqs[ 39] =  36;
          freqs[122] = 297; freqs[120] = 270; freqs[ 99] = 243; freqs[118] = 216; freqs[ 98] = 189; freqs[110] = 162;
              freqs[109] = 135; freqs[ 44] = 108; freqs[ 46] =  81; freqs[ 47] =  54; freqs[ 32] =  27;
    serial.printf("\033[2J");
    ticker.attach_us(&sample, 1000 * 1000 / FS);
    while (int i = serial.getc()) {
        if (i == 27) {
            serial.getc(); serial.getc(); i = serial.getc() - 48; serial.getc();
            if (i == 1) a >>= 1;
            if (i == 2) a <<= 1;
            if (i == 3) b *= 1.2;
            if (i == 4) b /= 1.2;
            if (i == 5) c = 0;
            if (i == 7) c = 1;
            serial.printf("i = %d; a = %05X; b = %f\r\n", i, a, b);
            continue;
        }
        as[n] = a;
        fs[n] = freqs[i] * 2;
        serial.printf("%d:%d\r\n", i, freqs[i]);
        if (c) n = (n + 1) % POLY;
    }
    ticker.detach();
    analogOut.write_u16(0);
}
