#include "mbed.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "TCPSocketServer.h"
#include "Websocket.h"
#include "motordriver.h"
#include "HTTPClient.h"

ESP8266Interface wifi(p28,p27,p26,"HOME-0392","D64D858A064D14BF",115200); // TX,RX,Reset,SSID,Password,Baud
Motor r(p22, p18, p17, 1);
Motor m(p21, p20, p19, 1); // pwm, fwd, rev
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX);

void forward()
{
    led1 = 1;
    r.speed(.6f);
    m.speed(.6f);
    wait(1.5);
    r.coast();
    m.coast();
    led1 = 0;
}
void backward()
{
    led2 = 1;
    r.speed(-.6f);
    m.speed(-.6f);
    wait(1.5);
    r.coast();
    m.coast();
    led2 = 0;
}
void left()
{
    led3 = 1;
    wait(.5);
    r.speed(.6f);
    m.speed(-.6f);
    wait(1.5);
    r.coast();
    m.coast();
    led3 = 0;
}
void right()
{
    led4 = 1;
    wait(.5);
    r.speed(-.6f);
    m.speed(.6f);
    wait(1.5);
    r.coast();
    m.coast();
    led4 = 0;
}

int main()
{
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    pc.printf("IP Address is %s\n", wifi.getIPAddress());

    Websocket ws("ws://10.0.0.16:8080/ws");
    if(!ws.connect()) {
        ws.close();
    } else {
        char str[10];
        char a;
        while(1) {
            //ready for new control
            sprintf(str, "1");
            pc.printf("%d",str);
            ws.send(str); //send to server stating ready for new instruction
            //memset(str,0,10);
            wait(0.5f);

            if(ws.read(str)) {
                pc.printf("%s\n", *str);
                a = str[0];
                pc.printf("%s",a);
                if(a=='1') {
                    forward();
                }
                if(a=='2') {
                    backward();
                }
                if(a=='3') {
                    left();
                }
                if(a=='4') {
                    right();
                }
            } else {
                //led1=led2=led3=led4=1;
            }
            //memset(str,0,10);
            wait(3);
        }
    }

}
