#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

EthernetInterface eth;
HTTPClient http;
char str[512];
HTTPText inData(str, 512);
Serial pc(USBTX, USBRX);
int ret;

int main()
{
    
    eth.init();
    ret = eth.connect();
    
     if (!ret) {
        pc.printf("ip: %s, %s, %s\r\n", eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    } else {
        pc.printf("Ethernet connect failed. ret: %d\r\n", ret);
        return -1;
    }

    HTTPMap map;
    map.put("value1", "Hello World.");
    ret = http.post("http://maker.ifttt.com/trigger/button_pressed/with/key/YOUR_SECRET_KEY", map, &inData);
    
    if (!ret) {
        pc.printf("HTTP request succeeded.\r\n");
        pc.printf("%s\r\n", str);
    } else {
        pc.printf("HTTP request failed. ret: %d, code: %d\r\n", ret, http.getHTTPResponseCode());
    }

    eth.disconnect();

    while(1) {
    }
}
