#include "mbed.h"
#include "MMA8451Q.h"
#include "SLCD.h"

/* 
Test of the accelerometer, digital I/O, on-board LCD screen.
 Looing at vector product of the x-y components of the accelerometer.
 Works pretty well. Still rough, program wise - sc 140710
 */

#define DATATIME 0.200

#define PROGNAME "ACCLCD341\r/n"

#define PRINTDBUG
// 
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;  // Data pins for the accelerometer/magnetometer.
  PinName const SCL = PTE24;  // DO NOT CHANGE
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

SLCD slcd; //define LCD display

MMA8451Q Acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX);

float sqrt_newt(float argument) {
    return (sqrt(argument));
}
   

void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 


int main() {
    float xAcc;
    float yAcc;
    float vector;  
    char lcdData[10]; //buffer needs places dor decimal pt and colon
    
#ifdef PRINTDBUG
        pc.printf(PROGNAME);
#endif
// main loop forever 
    while(true) {

//Get accelerometer data - tilt angles minus offset for zero mark.
        xAcc = abs(acc.getAccX());
        yAcc = abs(acc.getAccY());     
 // Calulate vector sum of x and y reading.       
        vector = sqrt_newt(pow(xAcc,2) + pow(yAcc,2));
        
 
#ifdef PRINTDBUG
        pc.printf("xAcc = %f\r\n", xAcc);
        pc.printf("yAcc = %f\r\n", yAcc);
        pc.printf("vector = %f\r\n",  vector);
#endif

        sprintf (lcdData,"%4.3f",vector);
        LCDMess(lcdData, DATATIME);
// Wait then do the whole thing again.
        wait(DATATIME);
    }
}