#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"
#define PROGNAME "Light_Sense_v1\n\r"
#define DATATIME 0.5
#define LCDLEN 10
#define PRINTDEBUG
#define LIGHTSENSORPORT PTE22
#define leftButton PTC12
#define rightButton PTC3
#define BUTUP true
#define BUTDOWN false
#define NUMBUTS 2
#define LEDON false
#define LEDOFF true
#define TSILIMIT 0.99
#define LCDCHARLEN 100


AnalogIn LightSensor(PTE22); // define light sensor
PwmOut redLed(LED_RED);
PwmOut greenLed(LED_GREEN);
SLCD slcd;
Serial pc(USBTX, USBRX);
Timer LEDTimer;
Ticker tick;

int ledState = LEDON;
int buttonStates[NUMBUTS] = {BUTDOWN,BUTUP};
DigitalIn buttons[NUMBUTS] = {rightButton, leftButton};
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};

volatile bool ticked;
float tsidata;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void tickFunction( void ) {
    ticked = true;
}

int main(){
    int i; 
    float lightVal;
    unsigned short lightWord;
    AnalogIn LightSensor(LIGHTSENSORPORT);
    float lightData; 
    char lcdData[LCDCHARLEN];
    ticked = false;
    tick.attach(&tickFunction, 0.10);
    TSISensor tsi;

    pc.printf(PROGNAME);
    
    int timeToChangeDF = DATATIME;
    LEDTimer.start();
    LEDTimer.reset();
    
    while (true) {
        lightVal = LightSensor.read();
        lightWord = LightSensor.read_u16();
        redLed = lightVal;
        greenLed = lightVal;

            for (i=0; i<NUMBUTS; i++){
                LEDs[i] = LEDON;      

                if(buttons[i] == BUTDOWN) {
                    if (i == 1){ 
                        while(1){
                            tsidata = tsi.readPercentage();
                            if(ticked){
                                if (tsidata > TSILIMIT){
                                greenLed = 0.0;
                                redLed = 0.0;
                                } else {
                                    pc.printf("\n Position %f\n\r", tsidata);
                                    sprintf (lcdData,"%0.4f",tsidata);  
                                    LCDMess(lcdData);  
                                    greenLed = 1.0 - tsidata;
                                    redLed = 1.0 - tsidata;
                                }
                            ticked = false;
                        } else {
                                       
                            if (LEDTimer.read_ms() > timeToChangeDF){ // check for timer time out transtion
                                lightData = (1.0 - LightSensor.read()); // show as increasiing with increasing intensity  
                                sprintf(lcdData,"%4.3f",lightData);       
                                LCDMess(lcdData);  
                                timeToChangeDF = DATATIME;
                                LEDTimer.reset();
                            }
                            if (lightVal == 0.900){
                                redLed = 1.0 + lightVal;
                                greenLed = 1.0 + lightVal;
                            }
                            if (lightVal == 0.800){
                                redLed = 1.0 + lightVal;
                                greenLed = 1.0 + lightVal;
                            }
                            if (lightVal == 0.700){
                                redLed = 1.0 + lightVal;
                                greenLed = 1.0 + lightVal;
                            }
                            if (lightVal == 0.600){
                                redLed = 1.0 + lightVal;
                                greenLed = 1.0 + lightVal;
                            }
                            if (lightVal == 0.500){
                                redLed = 1.0 + lightVal;
                                greenLed = 1.0 + lightVal;
                            }
                            if (lightVal == 0.400){
                            redLed = 1.0 + lightVal;
                            greenLed = 1.0 + lightVal;
                            }
                            if (lightVal == 0.300){
                                redLed = 1.0 + lightVal;
                                greenLed = 1.0 + lightVal;
                            }
                            if (lightVal == 0.200){
                                redLed = 1.0 + lightVal;
                                greenLed = 1.0 + lightVal;
                            }
                            if (lightVal == 0.100){
                                redLed = 1.0 + lightVal;
                                greenLed = 1.0 + lightVal;
                            }
                        }    
                    }
                }
            }
        }
            #ifdef PRINTDEBUG
            pc.printf("LS => %1.3f %5d \r\n", lightVal, lightWord);
            #endif
            wait(DATATIME);
        
        }
            
    }
