#include "mbed.h"
#include "TSISensor.h"
#include "SLCD.h"
#define TSILIMIT 0.99
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define PROGNAME "kl46z_slider_test_v1\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);
Ticker tick;

volatile bool ticked;

float tsidata;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

void tickFunction( void ) {
    ticked = true;
}

int main(void) {
    ticked = false;
    tick.attach(&tickFunction, 0.10);
    char lcdData[LCDCHARLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    pc.printf(PROGNAME);
    TSISensor tsi;

     while (1) {
        tsidata = tsi.readPercentage();
        if(ticked){
            if (tsidata > TSILIMIT){
                gled = 0.0;
                rled = 0.0;
            
            }else {
                pc.printf("\n Position %f\n\r", tsidata);
                sprintf (lcdData,"%0.4f",tsidata);  
                LCDMess(lcdData);  
                gled = tsidata;
                rled = 1.0 - tsidata;
            
            }
            //wait(DATAINTERVAL);
            ticked = false;
        }
    }
}