#include "mbed.h"
#include <math.h>  
#include "TSISensor.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define ARGUMENTSTATE 0
#define ANSWERSTATE 1
#define TSILIMIT 0.01
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.1
#define PROGNAME "kl46z_slider_mid_v1\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer dataTimer;
Timer ButtonTimer; // for reading button states
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
float tsidata;
int displayState;

//-------

//-------
void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset(); 
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}


int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    float lastTouch = 0.0;
    TSISensor tsi;
    float tempTSI;
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    float xnew;
    int intmax = 20;
    int n_int = 0;
    int epsilon = 1e-7;
    float delta;
       
    initialize_global_vars();
     while (true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    displayState = i;
                    
                        int xold = float(tsidata/2.0);
                        for(i = 0; i < intmax; i++){
                            xnew = 0.5 * (xold + (tsidata/xold));
                            delta = (abs(xnew-xold) );
                            sprintf(lcdData,"%0.03f",delta);

                            if(delta < epsilon){
                            break;
                            }else{
                                xold = xnew;
                                sprintf (lcdData,"%0.03f",delta);
     
                            }
                        }
                } 
            }
            ButtonTimer.reset();
            sprintf (lcdData,"%0.4f",delta);
            LCDMess(lcdData);
            rled = 0.0;
            gled = 1.0;
            
        }
        if(dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();                               
            tempTSI = tsi.readPercentage();        
            if (tempTSI > TSILIMIT){
                tsidata = tempTSI;
                if (fabs(tsidata - lastTouch)> PRINTDELTA){
                    pc.printf("Position %0.4f\n\r", tsidata);
                }           
            }
            lastTouch=tsidata;
        }
    }
}