#include "mbed.h"
#include "TSISensor.h"

#include <math.h>
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12
#define RBUT PTC3
#define ARGUMENTSTATE 0
#define ANSWERSTATE 1
#define TSILIMIT 0.01
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.2
#define EPSILONC 1e-7
#define LCDTITLE ""
#define TITLEWAIT 2.0

SLCD slcd;
Serial pc(USBTX, USBRX);
Timer dataTimer;
Timer ButtonTimer;
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
int displayState = ARGUMENTSTATE;
float tsidata;
float lcdArgument;
float kochOut;

float koch(float number,float delta,float min_num){
    if(number <= -5){
        return koch(number-delta, delta, min_num);
    }
    else{
        return 1;
    }
    
    
}

void intialize_global_vars(){
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset();
    lcdArgument = 50;
}    

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}
void showTitle(){
    LCDMess(LCDTITLE);
    wait(TITLEWAIT);
    return;
}

int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    float lastTouch = 0.0;
    TSISensor tsi;
    float tempTSI;
    int increment = 2;
    int min_number = -5;
    intialize_global_vars();
   
    showTitle();
   
    while (true){
        if(ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){
                if(!buttons[i]){
                    displayState = i;
                 }
             }
             ButtonTimer.reset();
             switch(displayState){
                    case ARGUMENTSTATE: {
                        lcdArgument = tsidata * 10;
                        sprintf (lcdData, "%4.1f",lcdArgument);
                        LCDMess(lcdData);
                        break;
                    }
                    case ANSWERSTATE :{
                        ///imoprt koch
                        kochOut = koch(lcdArgument,increment,min_number);
                        sprintf(lcdData,"4.2f",kochOut);
                        LCDMess(lcdData);
                        break;
                    }
                }
        }
        if(dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();
            tempTSI = tsi.readPercentage();
            if(tempTSI>TSILIMIT){
                tsidata = tempTSI;
                if(fabs(tsidata - lastTouch)>PRINTDELTA){
                    pc.printf("Position %0.4f\n\r", tsidata);
                }
            }
            lastTouch = tsidata;
        }
    }
}