#include "mbed.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define BUTDOWN false
#define BUTUP true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define BLINKTIME 0.05 // in seconds
#define BUTTONTIME 0.02
#define LCDCHARLEN 10
#define NUMMESS 2
#define LRED "RED"
#define LGREEN "GREEN"
#define PRED "RED\r\n"
#define PGREEN "GREEN\r\n"
#define REDMESS "RED LED is ON\r\n"
#define GREENMESS "GREEN LED is ON\r\n"p
#define PROGNAME "blink_kl46z_buttton LCD v2\r\n"

// slightly more interesting blinky 140814 sc
SLCD slcd; //define LCD display as a variaable



int ledState = LEDON;
int buttonStates[NUMBUTS] = {BUTDOWN, BUTUP};
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};

//needed port
Serial pc(USBTX, USBRX);

//
// Timer to elliminate wait() function
Timer LEDTimer; // for blinking LEDs
Timer ButtonTimer; // for reading button states

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}
void allLEDsOff(){
    int i;
    for (i=0; i<NUMBUTS; i++){ 
        LEDs[i] = LEDOFF;    
    }
}
int main(){
    
    int i; 
    int currentLED = 0;
    char rMess[NUMMESS][LCDCHARLEN]={LGREEN, LRED};
    char pMess[NUMMESS][LCDCHARLEN]={PRED,PGREEN};


     LEDs[currentLED] = LEDON;
    LCDMess(rMess[currentLED]);
    
    while(true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    allLEDsOff();  
                    LCDMess(rMess[i]);
                    currentLED = i;
                }
            }
        }
    while(true){
        for (i=0; i<NUMBUTS; i++){
            LEDs[i] = LEDOFF;
            if(!buttons[i]) {
                LCDMess(rMess[i]);
                
                currentLED = i;
            }
        }    
        ledState = !ledState;
        LEDs[currentLED] = ledState;
        wait(BLINKTIME);
    }   
}
}
