#include "mbed.h"
#include "MMA8451Q8g.h"
#include "SLCD.h"

#define BLINKTIME   1.5
#define RELAYON     0
#define RELAYOFF    1
#define LEDDELAY    0.4
#define WAITDELAY   0.7
#define LCDLEN      10

#define REG_WHO_AM_I      0x0D
#define XYZ_DATA_CFG      0x0E

#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05
#define REG_PULSE_CFG     0x21
#define REG_PULSE_SRC     0x22
#define REG_PULSE_THSZ    0x25
#define REH_PULSE_TMLT    0x26
#define REG_CTRL_4        0x2D
#define REG_CTRL_5        0x2E

#define MAX_2G            0x00
#define MAX_4G            0x01
#define MAX_8G            0x02
/**************************************
You need to fill nn the missing numbers below for this to work
0x00 is just a place holder 
*************************************/
#define LATCH_DATA        0x31  // for use in REG_PULSE_CFG
#define AXIS_DATA         0x2E
#define SET_INTERRUPT     0x2A     //using interrupt INT1 PTC5
#define SET_INT_LINE      0x2E

#define SET_THZ           0x17      //  See Table 49 in data sheet

#define SET_TMLT          0x26      // See Table 51 in data sheet
/*********************************************************/

//#define PRINTDBUG
// Accelerometer I2C pins
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
Ticker ledBlink; // timinginterrupt for RED led
InterruptIn MMA8451QInt1(PTC5);  //push botton with internal pullup
//InterruptIn MMA8451QInt1(PTD1);
DigitalOut myled(LED_RED); // red led
DigitalOut relay(LED_GREEN); // green led

 MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
 
float delay = WAITDELAY;
int relayState = RELAYOFF;
int outState = false;
SLCD slcd; //define LCD display
char LCDMessages[2][LCDLEN] = {"TRUE", "FALS"};


void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

// Interrupt routines
void LEDBlinker(){  // RED LED interrupt
    outState = !outState; 
    myled.write(outState);
}

void GreenLEDBlinker(){  // Green LED interrupt
    //uint8_t i_regData; 
    relayState = !relayState; 
    relay.write(relayState);
    //acc.readRegs(REG_PULSE_SRC, &i_regData, 1); // Clear the tap event
}        

// end interrupt routines

int main()
{
    uint8_t regData; 
    

    char lcdData[LCDLEN];
    
    myled.write(outState);
    relay.write(relayState);
    
// set up interrrupts to be used later for taps
    MMA8451QInt1.rise(&GreenLEDBlinker);
    MMA8451QInt1.mode(PullNone); 
   
// set up interrrupts to be used later for taps
    ledBlink.attach(&LEDBlinker, LEDDELAY);
  
// Read Pulse Source Data and check to see if things have been set
    acc.readRegs(REG_PULSE_CFG, &regData, 1);  // check it
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME); 
    
// *********** Initialize for tap tecognition ***********      
    regData = LATCH_DATA | AXIS_DATA;
    acc.setRegisterInStandby(REG_PULSE_CFG, regData); // write the data
    acc.readRegs(REG_PULSE_CFG, &regData, 1);  // check it
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME);     
    
// Check to see if accerlometer is alive and well
    acc.setGLimit(MAX_4G); // For now set to 2g
    acc.readRegs(XYZ_DATA_CFG, &regData, 1);
    sprintf (lcdData,"%x",regData); // Note displaying in hexidecimal
    LCDMess(lcdData,BLINKTIME);
    
// Setup single-tap pulse prarameters.
   acc.setRegisterInStandby(REG_PULSE_THSZ, SET_THZ); // write the data
   acc.setRegisterInStandby(REH_PULSE_TMLT, SET_TMLT); // write the data 
      
// Set up (pulse) interrupt to INT1 pin
    acc.setRegisterInStandby(REG_CTRL_4, SET_INTERRUPT); // write the data
    acc.setRegisterInStandby(REG_CTRL_5, SET_INT_LINE); // write the data
// End or seetup    

    acc.readRegs(REG_WHO_AM_I, &regData, 1);
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME); 
  
    
    while (true) { 
        acc.readRegs(REG_PULSE_SRC, &regData, 1);
        sprintf (lcdData,"%x",regData);
        LCDMess(lcdData,BLINKTIME);           
        LCDMessNoDwell(LCDMessages[relayState]);  
        wait(delay);
    }
}