#include "mbed.h"
#include <math.h> 
#include "MMA8451Q.h"
#include "SLCD.h"

/* 
Test of the accelerometer, digital I/O, on-board LCD screen.
 Looing at vector product of the x-y components of the accelerometer.
 Works pretty well. Still rough, program wise - sc 140710
 */

#define DATAINTERVAL 0.200
#define LCDDATALEN 10

#define LEDON false
#define LEDOFF true
#define BUTDOWN false
#define BUTUP true
#define NUMBUTS 2
#define LBUT PTC12
#define RBUT PTC3
#define LRED "Y "
#define LGREEN "X "
#define PRED "Y\r\n"
#define PGREEN "X\r\n"
#define NUMMESS 2

#define PROGNAME "ACCLCD341-541\r\n"

#define PRINTDBUG
// 
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;  // Data pins for the accelerometer/magnetometer.
  PinName const SCL = PTE24;  // DO NOT CHANGE
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

SLCD slcd; //define LCD display
char lcdData[LCDDATALEN]; //buffer needs places dor decimal pt and colon

int ledState = LEDON;
int buttonStates[NUMBUTS] = {BUTDOWN,BUTUP};
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX);
Timer dataTimer;

   

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void LCDsignedFloat(float theNumber){
    sprintf (lcdData," %3.2f",theNumber); 
    if (theNumber < 0.0) sprintf (lcdData,"<%3.2f",fabs(theNumber));   
    LCDMess(lcdData); 
} 

void initialize_global_vars(){
    pc.printf(PROGNAME);
    dataTimer.start();
    dataTimer.reset(); 
} 

int main() {
    float xAcc;
    float yAcc; 
    float zAcc; 
   //--------------
    int i; 
    int currentLED = 0;
    char rMess[NUMMESS][LCDDATALEN]={LGREEN, LRED};
    char pMess[NUMMESS][LCDDATALEN]={xAcc, yAcc};
   
    initialize_global_vars();
// main loop forever 
    while(true) {
        if(dataTimer.read() > DATAINTERVAL){
            dataTimer.reset();             
//Get accelerometer data - tilt angles minus offset for zero mark.
            xAcc = acc.getAccX();
            yAcc = acc.getAccY(); 
            zAcc = acc.getAccZ();     
 
 
 
            while(true) {
                for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1
                    LEDs[i] = LEDOFF;      
                // if(buttons[i] == BUTDOWN) {
                     if(!buttons[0]) {
                        LCDMess(rMess[0]);
                        wait(0.5);
                        //LCDMess(pMess[i]);
                        xAcc = acc.getAccX();
                        LCDsignedFloat(xAcc);
                        currentLED = 0;
                    }
                     if(!buttons[1]) {
                        LCDMess(rMess[1]);
                        wait(0.5);
                        yAcc = acc.getAccY(); 
                        LCDsignedFloat(yAcc);
                        currentLED = 1;
                    }
                }
                
                ledState = !ledState; // Flip the general state
                LEDs[currentLED] = ledState;
                wait(0.01);
               
 
                }
 
 
 
 
#ifdef PRINTDBUG
        pc.printf("xAcc = %f\r\n", xAcc);
        pc.printf("yAcc = %f\r\n", yAcc);
        pc.printf("zAcc = %f\r\n", zAcc);
#endif
        

        
// Wait then do the whole thing again.
       }
    }
}