// example to test the TFT Display from banggood.com
// Thanks to the GraphicsDisplay and TextDisplay classes
// test.bmp has to be on the mbed file system
// and on the sd-card

#include "stdio.h"
#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "SDFileSystem.h"
 
// the SD-connector is connected to SPI pin 11-13 
//SDFileSystem sd(p11, p12, p13, p14, "sd"); // mosi,miso,sck,cs
SDFileSystem sd(PTD2, PTD3, PTD1, PTA4, "sd"); // mosi,miso,sck,cs

// FRDM-KL25Z doesn't have external flash
//LocalFileSystem local("local");               // Create the local filesystem under the name "local"

//extern unsigned char p1[];  // the mbed logo graphic

// the display has a backlight switch on board 
//DigitalOut LCD_LED(p21);       

// the TFT is connected to SPI pin 5-7
//SPI_TFT_ILI9341 TFT(p5, p6, p7, p8, p9, p10,"TFT"); // mosi, miso, sclk, cs, reset, dc
SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1, PTD5, PTD0, PTD7,"TFT"); // mosi, miso, sclk, cs, reset, dc

int main()
{
    int i;
    //LCD_LED = 1;            // backlite on
   
    TFT.claim(stdout);        // send stdout to the TFT display
    TFT.set_orientation(1);
    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();                // clear the screen

    //first show the 4 directions
    TFT.set_orientation(0);
    TFT.background(Black);
    TFT.cls();

    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(0,0);
    printf("  Hello Mbed 0");
    TFT.set_orientation(1);
    TFT.locate(0,0);
    printf("  Hello Mbed 1");
    TFT.set_orientation(2);
    TFT.locate(0,0);
    printf("  Hello Mbed 2");
    TFT.set_orientation(3);
    TFT.locate(0,0);
    printf("  Hello Mbed 3");
    TFT.set_orientation(1);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(50,100);
    TFT.printf("TFT orientation");

    wait(5);        // wait two seconds

    // draw some graphics
    TFT.cls();
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(100,100);
    TFT.printf("Graphic");

    TFT.line(0,0,100,0,Green);
    TFT.line(0,0,0,200,Green);
    TFT.line(0,0,100,200,Green);

    TFT.rect(100,50,150,100,Red);
    TFT.fillrect(180,25,220,70,Blue);

    TFT.circle(80,150,33,White);
    TFT.fillcircle(160,190,20,Yellow);

    double s;

    for (i=0; i<320; i++) {
        s =20 * sin((long double) i / 10 );
        TFT.pixel(i,100 + (int)s ,Red);
    }

 
    wait(5);        // wait two seconds

    // bigger text
    TFT.foreground(White);
    TFT.background(Blue);
    TFT.cls();
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(0,0);
    TFT.printf("Different Fonts :");

    TFT.set_font((unsigned char*) Neu42x35);
    TFT.locate(10,30);
    TFT.printf("Hello Mbed 1");
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(20,80);
    TFT.printf("Hello Mbed 2");
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(35,120);
    TFT.printf("Hello Mbed 3");
    wait(5);

    TFT.background(Black);
    TFT.cls();
    //TFT.locate(10,10);
    //TFT.printf("Graphic from Flash");
    
    // mbed logo
    // defined in graphics.c
    //__align(4)
    //unsigned char p1[18920] = {
    //0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ....
    // 
    //TFT.Bitmap(90,90,172,55,p1);

    //wait(5);
    //TFT.cls();
    
    // to compare the speed of the internal file system and a SD-card
/*    TFT.locate(10,10);
    TFT.printf("Graphic from internal File System");
    TFT.locate(10,20);
    TFT.printf("open test.bmp");
    int err = TFT.BMP_16(1,50,"/local/test.bmp");
    if (err != 1) TFT.printf(" - Err: %d",err);
*/    
    TFT.locate(10,110);
    TFT.printf("Graphic from external SD-card");
    TFT.locate(10,120);
    int err = TFT.BMP_16(0,0,"/sd/teppy.bmp");    //1, 140
    if (err != 1) TFT.printf(" - Err: %d",err);    
}
