#include "mbed.h"
#include "DHT.h"

DigitalOut myled(LED_GREEN);
Serial pc(USBTX, USBRX);        // default baud 9600

DHT sensor(PTA11, DHT11);

int main() {
    int err;
    pc.printf("\nDHT11 Test Program\n");
    
    wait(1);    // wait 1 sec for device stable
    while (true) {
        myled = 0;  // 0: on
        err = sensor.readData();
        if (err == 0) {
            pc.printf("Temperature is %4.2f C \r\n", sensor.ReadTemperature(CELCIUS));
            pc.printf("Temperature is %4.2f F \r\n", sensor.ReadTemperature(FARENHEIT));
            pc.printf("Humidity is %4.f % \r\n", sensor.ReadHumidity());
            printf("Dew point is %4.2f  \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            printf("Dew point (fast) is %4.2f  \r\n\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
        }
        else {
            printf("\r\nErr %i \n", err);    
        }
        myled = 1;
        wait(15);
    }
}
