#include "L298LIB.h"
L298LIB::L298LIB(PinName pinEnable, PinName pinIN1, PinName pinIN2, PinName pinIN3, PinName pinIN4):
    _pwm(pinEnable),
    _pinIN1 (pinIN1),
    _pinIN2 (pinIN2),
    _pinIN3 (pinIN3),
    _pinIN4 (pinIN4)
{
    _pwm.period_us(25); // 40kHz
    _pwm = 0.;
    _pinIN1 = 0;
    _pinIN2 = 0;
    _pinIN3 = 0;
    _pinIN4 = 0;
}
void L298LIB::setSpeed(float pwmVal)
{
    _pwm = pwmVal;
}
float L298LIB::getSpeed()
{
    return _pwm;
}
void L298LIB::forward()
{
    _pinIN1=1;
    _pinIN2=0;
    _pinIN3=1;
    _pinIN4=0;
}
void L298LIB::backward()
{
    _pinIN1=0;
    _pinIN2=1;
    _pinIN3=0;
    _pinIN4=1;
}
void L298LIB::stop()
{
    _pinIN1=0;
    _pinIN2=0;
    _pinIN3=0;
    _pinIN4=0;
}
void L298LIB::run(float vel)
{
    if (vel>=0) {
        setSpeed((vel>1.0f) ? 1.0f:vel);
        forward();
    } else {
        setSpeed((vel<-1.0f) ? 1.0f:-vel);
        backward();
    }
}