#include "mbed.h"
#include "XNucleo53L0A1.h"
#include "TCS3200.h"
#include <stdio.h>

#define VL53L0_I2C_SDA   D4
#define VL53L0_I2C_SCL   D5

#define NOT_RECEIVE 0
#define RED_RECEIVE 1
#define BLUE_RECEIVE 2
#define YELLOW_RECIEVE 3


TCS3200 color(PB_5, PB_2, PC_4);//カラーセンサ
static XNucleo53L0A1 *board=NULL;
int count = 0;
int red_count = 0;
int blue_count = 0;
int mode = NOT_RECEIVE;

int main(){
    long red, green, blue, clear;
    int status;
    uint32_t distance;
    DevI2C *device_i2c = new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);
    board = XNucleo53L0A1::instance(device_i2c, A2, D8, D2);
    status = board->init_board();
    if (status) {
        printf("Failed to init board!\r\n");
        return 0;
    }
   while (1) {
        status = board->sensor_centre->get_distance(&distance);
        red = color.ReadRed();
        blue = color.ReadBlue();
        clear = color.ReadClear();
        if(clear <= 30 && distance <= 1000){
            count++;
        }
        if(count >= 1000){
            if(red <= 40 && green >= 80 && blue >= 70){
                red_count++;
            }else if(red >= 80 && green >= 60 && blue <= 40){
                blue_count++;
            }
            count = 0;
        }
        if(red_count >= 1000 && distance >= 2000){
            mode = RED_RECEIVE;
            red_count = 0;
        }else if(blue_count >= 1000 && distance >= 2000){
            mode = BLUE_RECEIVE;
            blue_count = 0;
        }    
    }
}
