#include "mbed.h"
#include "moter.h"

void Straight(float RPower, float LPower, PwmOut *m_pins, DigitalOut *d_pins1 ,DigitalOut *d_pins2){
    m_pins[0] = RPower;
    m_pins[1] = RPower;
    m_pins[2] = LPower;
    m_pins[3] = LPower;
    for(int i=0;i<4;i++){
        d_pins1[i] = 1.0;
        d_pins2[i] = 0.0;
    }
}

void Back(float RPower, float LPower, PwmOut *m_pins, DigitalOut *d_pins1 ,DigitalOut *d_pins2){
    m_pins[0] = LPower;
    m_pins[1] = LPower;
    m_pins[2] = RPower;
    m_pins[3] = RPower;
    for(int i=0;i<4;i++){
        d_pins1[i] = 0.0;
        d_pins2[i] = 1.0;
    }
}

void Right(float RPower, float LPower, PwmOut *m_pins, DigitalOut *d_pins1 ,DigitalOut *d_pins2){
    m_pins[0] = LPower;
    m_pins[1] = RPower;
    m_pins[2] = LPower;
    m_pins[3] = RPower;
    d_pins1[0] = 0.0;
    d_pins1[1] = 1.0;
    d_pins1[2] = 1.0;
    d_pins1[3] = 0.0;
    d_pins2[0] = 1.0;
    d_pins2[1] = 0.0;
    d_pins2[2] = 0.0;
    d_pins2[3] = 1.0;

}

void Left(float RPower, float LPower, PwmOut *m_pins, DigitalOut *d_pins1 ,DigitalOut *d_pins2){
    m_pins[0] = RPower;
    m_pins[1] = LPower;
    m_pins[2] = RPower;
    m_pins[3] = LPower;
    d_pins1[0] = 1.0;
    d_pins1[1] = 0.0;
    d_pins1[2] = 0.0;
    d_pins1[3] = 1.0;
    d_pins2[0] = 0.0;
    d_pins2[1] = 1.0;
    d_pins2[2] = 1.0;
    d_pins2[3] = 0.0;

}

void Stop(PwmOut *m_pins, DigitalOut *d_pins1, DigitalOut *d_pins2){
    for(int i=0;i<4;i++){
        m_pins[i] = 0.0;
        d_pins1[i] = 1.0;
        d_pins2[i] = 1.0;
    }        
}