
#ifndef KBT_H
#define KBT_H

#include "mbed.h"

#define BITNUM 8
#define DATANUM 7

#define rect 0
#define L1 1
#define L2 2
#define R1 3
#define R2 4
#define up 5
#define down 6
#define right 7
#define left 8
#define triangle 9
#define cross 10
#define circle 11
#define Start 12
#define Select 13
#define L_around 14
#define L_updown 15
#define R_around 16
#define R_updown 17

class KBT{
public  :
    bool Button[14];
    double Stick[4];
    int open_data[8];
    
    KBT(PinName TX, PinName RX);
    void init(long baudrate);
    bool button(int num);
    double stick(int num);
    void putc(int val);
    
private :
    Serial bt;
    
    bool start;
    int stopcheck;
    int val;
    int count;
    int bitbox[8];
    int data[8];
    int check[9];

    double map(double x, double in_min, double in_max, double out_min, double out_max);
    void bitcheck();
    void intSerial();
    void numinit();
    
};

#endif

