
#include "kbt.h"
#include "mbed.h"


double KBT::map(double x, double in_min, double in_max, double out_min, double out_max){
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

KBT::KBT(PinName TX, PinName RX) : bt(TX,RX) {
}

void KBT::init(long baudrate){
    numinit();
    bt.baud(baudrate);
    bt.attach(this, &KBT::intSerial, Serial::RxIrq);
}

void KBT::numinit(){
    start = 0;
    stopcheck = 0;
    val = 0; 
    count = 0;
    bitbox[0] = data[0] = open_data[0] = 0x80;
    bitbox[1] = data[1] = open_data[1] = 0x00;
    bitbox[2] = data[2] = open_data[2] = 0x00;
    bitbox[3] = data[3] = open_data[3] = 0x40;
    bitbox[4] = data[4] = open_data[4] = 0x40;
    bitbox[5] = data[5] = open_data[5] = 0x40;
    bitbox[6] = data[6] = open_data[6] = 0x40;
    bitbox[7] = data[7] = open_data[7] = 0x00;
    check[0] = 0x01;
    check[1] = 0x02; 
    check[2] = 0x04;
    check[3] = 0x08;
    check[4] = 0x10;
    check[5] = 0x20;
    check[6] = 0x40;
    check[7] = 0x03;
    check[8] = 0x0C;
}
void KBT::putc(int val){
    bt.putc(val);
}

bool KBT::button(int num){
    return Button[num];
}

double KBT::stick(int num){
    return Stick[num - 14];
}

void KBT::bitcheck(){
    for(int i=0;i<5;i++){
        if(bitbox[1] == check[i]){
            Button[i] = true;
        }else{
            Button[i] = 0;
        }
    }
    for(int i=0;i<9;i++){
        if(bitbox[2] == check[i]){
            Button[i+5] = true; 
        }else{
            Button[i+5] = 0;
        }
    }
    if(bitbox[3] == 0x40){
        Stick[0] = 0;
    }else if(bitbox[3] < 0x40){
        Stick[0] = map(bitbox[3], 65, 0, 0, 1);
    }else if(bitbox[3] > 0x40){
        Stick[0] = map(bitbox[3], 63, 127, 0, -1);
    }
    
    if(bitbox[4] == 0x40){
        Stick[1] = 0;
    }else if(bitbox[4] < 0x40){
        Stick[1] = map(bitbox[4], 63, 127, 0, -1);
    }else if(bitbox[4] > 0x40){
        Stick[1] = map(bitbox[4], 65, 0, 0, 1);
    }

    if(bitbox[5] == 0x40){
        Stick[2] = 0;
    }else if(bitbox[5] < 0x40){
        Stick[2] = map(bitbox[5], 65, 0, 0, -1);
    }else if(bitbox[5] > 0x40){
        Stick[2] = map(bitbox[5], 63, 127, 0, 1);
    }

    if(bitbox[6] == 0x40){
        Stick[3] = 0;
    }else if(bitbox[6] < 0x40){
        Stick[3] = map(bitbox[6], 65, 0, 0, 1);
    }else if(bitbox[6] > 0x40){
        Stick[3] = map(bitbox[6], 63, 127, 0, -1);
    }
}

    
void KBT::intSerial(){
    val = bt.getc();
    if(val == 0x80){
        bitbox[0] = val;
        start = 1;
        count = 1;
        stopcheck = 0;
    }else{
        if(start == 1){
            bitbox[count] = val;
            count++;
        }
        if(count >= BITNUM){
            for(int i=1;i<DATANUM;i++){
                stopcheck += bitbox[i];
            }
            if((stopcheck & 0b01111111) == bitbox[DATANUM]){
                for(int i=0;i<BITNUM;i++){
                    data[i] = bitbox[i];
                    open_data[i] = data[i];
                }
            }
            bitcheck();
            count=0;
            start=0;
        }
    }
}